/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.apache.cassandra.net.SelectionKeyHandler;
import org.apache.log4j.Logger;

public class SelectorManager
extends Thread {
    private static final Logger logger = Logger.getLogger(SelectorManager.class);
    protected Selector selector;
    Object gate = new Object();
    private static SelectorManager manager;
    private static SelectorManager udpManager;

    private SelectorManager(String name) {
        super(name);
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setDaemon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey register(SelectableChannel channel, SelectionKeyHandler handler, int ops) throws IOException {
        assert (channel != null);
        assert (handler != null);
        Object object = this.gate;
        synchronized (object) {
            this.selector.wakeup();
            return channel.register(this.selector, ops, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                this.selector.select(1L);
                this.doProcess();
                Object object = this.gate;
                // MONITORENTER : object
                // MONITOREXIT : object
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doProcess() throws IOException {
        SelectionKey[] keys;
        for (SelectionKey key : keys = this.selector.selectedKeys().toArray(new SelectionKey[0])) {
            this.selector.selectedKeys().remove(key);
            SelectionKeyHandler skh = (SelectionKeyHandler)key.attachment();
            if (skh == null) continue;
            if (key.isValid() && key.isAcceptable()) {
                skh.accept(key);
            }
            if (key.isValid() && key.isConnectable()) {
                skh.connect(key);
            }
            if (key.isValid() && key.isReadable()) {
                skh.read(key);
            }
            if (!key.isValid() || !key.isWritable()) continue;
            skh.write(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectorManager getSelectorManager() {
        Class<SelectorManager> clazz = SelectorManager.class;
        synchronized (SelectorManager.class) {
            if (manager == null) {
                manager = new SelectorManager("TCP Selector Manager");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectorManager getUdpSelectorManager() {
        Class<SelectorManager> clazz = SelectorManager.class;
        synchronized (SelectorManager.class) {
            if (udpManager == null) {
                udpManager = new SelectorManager("UDP Selector Manager");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return udpManager;
        }
    }
}

