/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.net.SocketException;
import org.apache.cassandra.concurrent.Context;
import org.apache.cassandra.concurrent.ThreadLocalContext;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.TcpConnection;
import org.apache.cassandra.net.sink.SinkManager;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

class MessageSerializationTask
implements Runnable {
    private static Logger logger_ = Logger.getLogger(MessageSerializationTask.class);
    private Message message_;
    private EndPoint to_;

    public MessageSerializationTask(Message message, EndPoint to) {
        this.message_ = message;
        this.to_ = to;
    }

    public Message getMessage() {
        return this.message_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Context ctx = new Context();
        ctx.put(this.getClass().getName(), this.message_);
        ThreadLocalContext.put(ctx);
        TcpConnection connection = null;
        try {
            Message message = SinkManager.processClientMessageSink(this.message_);
            if (null == message) {
                return;
            }
            connection = MessagingService.getConnection(this.message_.getFrom(), this.to_);
            connection.write(message);
        }
        catch (SocketException se) {
            MessagingService.getConnectionPool(this.message_.getFrom(), this.to_).shutdown();
            logger_.warn((Object)LogUtil.throwableToString(se));
        }
        catch (IOException e) {
            this.logConnectAndIOException(e, connection);
        }
        catch (Throwable th) {
            logger_.warn((Object)LogUtil.throwableToString(th));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void logConnectAndIOException(IOException ex, TcpConnection connection) {
        if (connection != null) {
            connection.errorClose();
        }
        logger_.warn((Object)LogUtil.throwableToString(ex));
    }
}

