/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.Serializable;
import java.util.Map;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.net.MessageSerializer;

public class Message
implements Serializable {
    static final long serialVersionUID = 6329198792470413221L;
    private static ICompactSerializer<Message> serializer_ = new MessageSerializer();
    Header header_;
    private byte[] body_;

    public static ICompactSerializer<Message> serializer() {
        return serializer_;
    }

    protected Message(String id, EndPoint from, String messageType, String verb, byte[] body) {
        this(new Header(id, from, messageType, verb), body);
    }

    protected Message(Header header, byte[] body) {
        this.header_ = header;
        this.body_ = body;
    }

    public Message(EndPoint from, String messageType, String verb, byte[] body) {
        this(new Header(from, messageType, verb), body);
    }

    public byte[] getHeader(Object key) {
        return this.header_.getDetail(key);
    }

    public void removeHeader(Object key) {
        this.header_.removeDetail(key);
    }

    public void setMessageType(String type) {
        this.header_.setMessageType(type);
    }

    public void setMessageVerb(String verb) {
        this.header_.setMessageVerb(verb);
    }

    public void addHeader(String key, byte[] value) {
        this.header_.addDetail(key, value);
    }

    public Map<String, byte[]> getHeaders() {
        return this.header_.getDetails();
    }

    public byte[] getMessageBody() {
        return this.body_;
    }

    public void setMessageBody(byte[] body) {
        this.body_ = body;
    }

    public EndPoint getFrom() {
        return this.header_.getFrom();
    }

    public String getMessageType() {
        return this.header_.getMessageType();
    }

    public String getVerb() {
        return this.header_.getVerb();
    }

    public String getMessageId() {
        return this.header_.getMessageId();
    }

    void setMessageId(String id) {
        this.header_.setMessageId(id);
    }

    public Message getReply(EndPoint from, byte[] args) {
        Message response = new Message(this.getMessageId(), from, "RESPONSE-STAGE", "RESPONSE", args);
        return response;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("");
        String separator = System.getProperty("line.separator");
        sbuf.append("ID:" + this.getMessageId()).append(separator).append("FROM:" + this.getFrom()).append(separator).append("TYPE:" + this.getMessageType()).append(separator).append("VERB:" + this.getVerb()).append(separator);
        return sbuf.toString();
    }
}

