/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.TcpConnection;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

class FileStreamTask
implements Runnable {
    private static Logger logger_ = Logger.getLogger(FileStreamTask.class);
    private String file_;
    private long startPosition_;
    private long total_;
    private EndPoint from_;
    private EndPoint to_;

    FileStreamTask(String file, long startPosition, long total, EndPoint from, EndPoint to) {
        this.file_ = file;
        this.startPosition_ = startPosition;
        this.total_ = total;
        this.from_ = from;
        this.to_ = to;
    }

    @Override
    public void run() {
        TcpConnection connection = null;
        try {
            connection = new TcpConnection(this.from_, this.to_);
            File file = new File(this.file_);
            connection.stream(file, this.startPosition_, this.total_);
            MessagingService.setStreamingMode(false);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Done streaming " + file));
            }
        }
        catch (SocketException se) {
            logger_.info((Object)LogUtil.throwableToString(se));
        }
        catch (IOException e) {
            this.logConnectAndIOException(e, connection);
        }
        catch (Throwable th) {
            logger_.warn((Object)LogUtil.throwableToString(th));
        }
    }

    private void logConnectAndIOException(IOException ex, TcpConnection connection) {
        if (connection != null) {
            connection.errorClose();
        }
        logger_.info((Object)LogUtil.throwableToString(ex));
    }
}

