/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.EndPoint;

public class RackUnawareStrategy
extends AbstractReplicationStrategy {
    public RackUnawareStrategy(TokenMetadata tokenMetadata, IPartitioner partitioner, int replicas, int storagePort) {
        super(tokenMetadata, partitioner, replicas, storagePort);
    }

    @Override
    public EndPoint[] getReadStorageEndPoints(Token token) {
        return this.getReadStorageEndPoints(token, this.tokenMetadata_.cloneTokenEndPointMap());
    }

    @Override
    public EndPoint[] getWriteStorageEndPoints(Token token) {
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        Map<Token, EndPoint> bootstrapTokensToEndpointMap = this.tokenMetadata_.cloneBootstrapNodes();
        List<Token> tokenList = this.getStorageTokens(token, tokenToEndPointMap, bootstrapTokensToEndpointMap);
        ArrayList<EndPoint> list = new ArrayList<EndPoint>();
        for (Token t : tokenList) {
            EndPoint e = tokenToEndPointMap.get(t);
            if (e == null) {
                e = bootstrapTokensToEndpointMap.get(t);
            }
            assert (e != null);
            list.add(e);
        }
        this.retrofitPorts(list);
        return list.toArray(new EndPoint[list.size()]);
    }

    @Override
    public EndPoint[] getReadStorageEndPoints(Token token, Map<Token, EndPoint> tokenToEndPointMap) {
        List<Token> tokenList = this.getStorageTokens(token, tokenToEndPointMap, null);
        ArrayList<EndPoint> list = new ArrayList<EndPoint>();
        for (Token t : tokenList) {
            list.add(tokenToEndPointMap.get(t));
        }
        this.retrofitPorts(list);
        return list.toArray(new EndPoint[list.size()]);
    }

    private List<Token> getStorageTokens(Token token, Map<Token, EndPoint> tokenToEndPointMap, Map<Token, EndPoint> bootStrapTokenToEndPointMap) {
        int startIndex;
        ArrayList<Token> tokenList = new ArrayList<Token>();
        int foundCount = 0;
        ArrayList<Token> tokens = new ArrayList<Token>(tokenToEndPointMap.keySet());
        ArrayList<Token> bsTokens = null;
        if (bootStrapTokenToEndPointMap != null) {
            bsTokens = new ArrayList<Token>(bootStrapTokenToEndPointMap.keySet());
            tokens.addAll(bsTokens);
        }
        Collections.sort(tokens);
        int index = Collections.binarySearch(tokens, token);
        if (index < 0 && (index = (index + 1) * -1) >= tokens.size()) {
            index = 0;
        }
        int totalNodes = tokens.size();
        tokenList.add((Token)tokens.get(index));
        if (bsTokens == null || !bsTokens.contains(tokens.get(index))) {
            ++foundCount;
        }
        int i = startIndex = (index + 1) % totalNodes;
        for (int count = 1; count < totalNodes && foundCount < this.replicas_; ++count) {
            if (!tokenList.contains(tokens.get(i))) {
                tokenList.add((Token)tokens.get(i));
                if (bsTokens == null || !bsTokens.contains(tokens.get(i))) {
                    ++foundCount;
                }
            }
            i = (i + 1) % totalNodes;
        }
        return tokenList;
    }
}

