/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cassandra.concurrent.SingleThreadedStage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAck2Message;
import org.apache.cassandra.gms.GossipDigestAck2VerbHandler;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestAckVerbHandler;
import org.apache.cassandra.gms.GossipDigestSynMessage;
import org.apache.cassandra.gms.GossipDigestSynVerbHandler;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.IEndPointStateChangePublisher;
import org.apache.cassandra.gms.IEndPointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.JoinVerbHandler;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class Gossiper
implements IFailureDetectionEventListener,
IEndPointStateChangePublisher {
    static final int MAX_GOSSIP_PACKET_SIZE = 1428;
    static final String GOSSIP_STAGE = "GS";
    static final String JOIN_VERB_HANDLER = "JVH";
    static final String GOSSIP_DIGEST_SYN_VERB = "GSV";
    static final String GOSSIP_DIGEST_ACK_VERB = "GAV";
    static final String GOSSIP_DIGEST_ACK2_VERB = "GA2V";
    static final int intervalInMillis_ = 1000;
    private static Logger logger_ = Logger.getLogger(Gossiper.class);
    static Gossiper gossiper_;
    private Timer gossipTimer_ = new Timer(false);
    private EndPoint localEndPoint_;
    private long aVeryLongTime_ = 259200000L;
    private Random random_ = new Random();
    private int rrIndex_ = 0;
    private List<IEndPointStateChangeSubscriber> subscribers_ = new ArrayList<IEndPointStateChangeSubscriber>();
    private Set<EndPoint> liveEndpoints_ = new HashSet<EndPoint>();
    private Set<EndPoint> unreachableEndpoints_ = new HashSet<EndPoint>();
    private Set<EndPoint> seeds_ = new HashSet<EndPoint>();
    Map<EndPoint, EndPointState> endPointStateMap_ = new Hashtable<EndPoint, EndPointState>();

    public static synchronized Gossiper instance() {
        if (gossiper_ == null) {
            gossiper_ = new Gossiper();
        }
        return gossiper_;
    }

    Gossiper() {
        FailureDetector.instance().registerFailureDetectionEventListener(this);
        MessagingService.getMessagingInstance().registerVerbHandlers(JOIN_VERB_HANDLER, new JoinVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(GOSSIP_DIGEST_SYN_VERB, new GossipDigestSynVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(GOSSIP_DIGEST_ACK_VERB, new GossipDigestAckVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(GOSSIP_DIGEST_ACK2_VERB, new GossipDigestAck2VerbHandler());
        StageManager.registerStage(GOSSIP_STAGE, new SingleThreadedStage("GMFD"));
    }

    @Override
    public void register(IEndPointStateChangeSubscriber subscriber) {
        this.subscribers_.add(subscriber);
    }

    @Override
    public void unregister(IEndPointStateChangeSubscriber subscriber) {
        this.subscribers_.remove(subscriber);
    }

    public Set<EndPoint> getAllMembers() {
        HashSet<EndPoint> allMbrs = new HashSet<EndPoint>();
        allMbrs.addAll(this.getLiveMembers());
        allMbrs.addAll(this.getUnreachableMembers());
        return allMbrs;
    }

    public Set<EndPoint> getLiveMembers() {
        HashSet<EndPoint> liveMbrs = new HashSet<EndPoint>(this.liveEndpoints_);
        liveMbrs.add(new EndPoint(this.localEndPoint_.getHost(), this.localEndPoint_.getPort()));
        return liveMbrs;
    }

    public Set<EndPoint> getUnreachableMembers() {
        return new HashSet<EndPoint>(this.unreachableEndpoints_);
    }

    public synchronized void removeFromMembership(EndPoint ep) {
        this.endPointStateMap_.remove(ep);
        this.liveEndpoints_.remove(ep);
        this.unreachableEndpoints_.remove(ep);
    }

    @Override
    public void convict(EndPoint endpoint) {
        EndPointState epState = this.endPointStateMap_.get(endpoint);
        if (epState != null && !epState.isAlive() && epState.isAGossiper()) {
            if (this.liveEndpoints_.contains(endpoint)) {
                logger_.info((Object)("EndPoint " + endpoint + " is now dead."));
                this.isAlive(endpoint, epState, false);
                EndPointState deltaState = new EndPointState(epState.getHeartBeatState());
                this.doNotifications(endpoint, deltaState);
            }
            epState.isAGossiper(false);
        }
    }

    @Override
    public void suspect(EndPoint endpoint) {
        EndPointState epState = this.endPointStateMap_.get(endpoint);
        if (epState.isAlive()) {
            logger_.info((Object)("EndPoint " + endpoint + " is now dead."));
            this.isAlive(endpoint, epState, false);
            EndPointState deltaState = new EndPointState(epState.getHeartBeatState());
            this.doNotifications(endpoint, deltaState);
        }
    }

    int getMaxEndPointStateVersion(EndPointState epState) {
        ArrayList<Integer> versions = new ArrayList<Integer>();
        versions.add(epState.getHeartBeatState().getHeartBeatVersion());
        Map<String, ApplicationState> appStateMap = epState.getApplicationState();
        Set<String> keys = appStateMap.keySet();
        for (String key : keys) {
            int stateVersion = appStateMap.get(key).getStateVersion();
            versions.add(stateVersion);
        }
        Collections.sort(versions);
        int maxVersion = (Integer)versions.get(versions.size() - 1);
        versions.clear();
        return maxVersion;
    }

    void evictFromMembership(EndPoint endpoint) {
        this.unreachableEndpoints_.remove(endpoint);
    }

    @Deprecated
    void makeGossipDigest(List<GossipDigest> gDigests) {
        EndPointState epState = this.endPointStateMap_.get(this.localEndPoint_);
        int generation = epState.getHeartBeatState().getGeneration();
        int maxVersion = this.getMaxEndPointStateVersion(epState);
        gDigests.add(new GossipDigest(this.localEndPoint_, generation, maxVersion));
        for (EndPoint liveEndPoint : this.liveEndpoints_) {
            epState = this.endPointStateMap_.get(liveEndPoint);
            if (epState != null) {
                generation = epState.getHeartBeatState().getGeneration();
                maxVersion = this.getMaxEndPointStateVersion(epState);
                gDigests.add(new GossipDigest(liveEndPoint, generation, maxVersion));
                continue;
            }
            gDigests.add(new GossipDigest(liveEndPoint, 0, 0));
        }
    }

    void makeRandomGossipDigest(List<GossipDigest> gDigests) {
        EndPointState epState = this.endPointStateMap_.get(this.localEndPoint_);
        int generation = epState.getHeartBeatState().getGeneration();
        int maxVersion = this.getMaxEndPointStateVersion(epState);
        gDigests.add(new GossipDigest(this.localEndPoint_, generation, maxVersion));
        ArrayList<EndPoint> endpoints = new ArrayList<EndPoint>(this.liveEndpoints_);
        Collections.shuffle(endpoints, this.random_);
        for (EndPoint liveEndPoint : endpoints) {
            epState = this.endPointStateMap_.get(liveEndPoint);
            if (epState != null) {
                generation = epState.getHeartBeatState().getGeneration();
                maxVersion = this.getMaxEndPointStateVersion(epState);
                gDigests.add(new GossipDigest(liveEndPoint, generation, maxVersion));
                continue;
            }
            gDigests.add(new GossipDigest(liveEndPoint, 0, 0));
        }
        StringBuilder sb = new StringBuilder();
        for (GossipDigest gDigest : gDigests) {
            sb.append(gDigest);
            sb.append(" ");
        }
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Gossip Digests are : " + sb.toString()));
        }
    }

    public int getCurrentGenerationNumber(EndPoint endpoint) {
        return this.endPointStateMap_.get(endpoint).getHeartBeatState().getGeneration();
    }

    Message makeGossipDigestSynMessage(List<GossipDigest> gDigests) throws IOException {
        GossipDigestSynMessage gDigestMessage = new GossipDigestSynMessage(DatabaseDescriptor.getClusterName(), gDigests);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1428);
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestSynMessage.serializer().serialize(gDigestMessage, dos);
        Message message = new Message(this.localEndPoint_, GOSSIP_STAGE, GOSSIP_DIGEST_SYN_VERB, bos.toByteArray());
        return message;
    }

    Message makeGossipDigestAckMessage(GossipDigestAckMessage gDigestAckMessage) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1428);
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestAckMessage.serializer().serialize(gDigestAckMessage, dos);
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("@@@@ Size of GossipDigestAckMessage is " + bos.toByteArray().length));
        }
        Message message = new Message(this.localEndPoint_, GOSSIP_STAGE, GOSSIP_DIGEST_ACK_VERB, bos.toByteArray());
        return message;
    }

    Message makeGossipDigestAck2Message(GossipDigestAck2Message gDigestAck2Message) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1428);
        DataOutputStream dos = new DataOutputStream(bos);
        GossipDigestAck2Message.serializer().serialize(gDigestAck2Message, dos);
        Message message = new Message(this.localEndPoint_, GOSSIP_STAGE, GOSSIP_DIGEST_ACK2_VERB, bos.toByteArray());
        return message;
    }

    boolean sendGossipToLiveNode(Message message) {
        int size = this.liveEndpoints_.size();
        ArrayList<EndPoint> eps = new ArrayList<EndPoint>(this.liveEndpoints_);
        if (this.rrIndex_ >= size) {
            this.rrIndex_ = -1;
        }
        EndPoint to = (EndPoint)eps.get(++this.rrIndex_);
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Sending a GossipDigestSynMessage to " + to + " ..."));
        }
        MessagingService.getMessagingInstance().sendUdpOneWay(message, to);
        return this.seeds_.contains(to);
    }

    boolean sendGossip(Message message, Set<EndPoint> epSet) {
        int size = epSet.size();
        ArrayList<EndPoint> liveEndPoints = new ArrayList<EndPoint>(epSet);
        int index = size == 1 ? 0 : this.random_.nextInt(size);
        EndPoint to = (EndPoint)liveEndPoints.get(index);
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Sending a GossipDigestSynMessage to " + to + " ..."));
        }
        MessagingService.getMessagingInstance().sendUdpOneWay(message, to);
        return this.seeds_.contains(to);
    }

    boolean doGossipToLiveMember(Message message) {
        int size = this.liveEndpoints_.size();
        if (size == 0) {
            return false;
        }
        return this.sendGossip(message, this.liveEndpoints_);
    }

    void doGossipToUnreachableMember(Message message) {
        double liveEndPoints = this.liveEndpoints_.size();
        double unreachableEndPoints = this.unreachableEndpoints_.size();
        if (unreachableEndPoints > 0.0) {
            double prob = unreachableEndPoints / (liveEndPoints + 1.0);
            double randDbl = this.random_.nextDouble();
            if (randDbl < prob) {
                this.sendGossip(message, this.unreachableEndpoints_);
            }
        }
    }

    void doGossipToSeed(Message message) {
        int size = this.seeds_.size();
        if (size > 0) {
            if (size == 1 && this.seeds_.contains(this.localEndPoint_)) {
                return;
            }
            if (this.liveEndpoints_.size() == 0) {
                this.sendGossip(message, this.seeds_);
            } else {
                double probability = (double)this.seeds_.size() / (double)(this.liveEndpoints_.size() + this.unreachableEndpoints_.size());
                double randDbl = this.random_.nextDouble();
                if (randDbl <= probability) {
                    this.sendGossip(message, this.seeds_);
                }
            }
        }
    }

    void doStatusCheck() {
        Set<EndPoint> eps = this.endPointStateMap_.keySet();
        for (EndPoint endpoint : eps) {
            if (endpoint.equals(this.localEndPoint_)) continue;
            FailureDetector.instance().interpret(endpoint);
            EndPointState epState = this.endPointStateMap_.get(endpoint);
            if (epState == null) continue;
            long duration = System.currentTimeMillis() - epState.getUpdateTimestamp();
            if (epState.isAlive() || duration <= this.aVeryLongTime_) continue;
            this.evictFromMembership(endpoint);
        }
    }

    EndPointState getEndPointStateForEndPoint(EndPoint ep) {
        return this.endPointStateMap_.get(ep);
    }

    synchronized EndPointState getStateForVersionBiggerThan(EndPoint forEndpoint, int version) {
        EndPointState epState = this.endPointStateMap_.get(forEndpoint);
        EndPointState reqdEndPointState = null;
        if (epState != null) {
            int localHbVersion = epState.getHeartBeatState().getHeartBeatVersion();
            if (localHbVersion > version) {
                reqdEndPointState = new EndPointState(epState.getHeartBeatState());
            }
            Map<String, ApplicationState> appStateMap = epState.getApplicationState();
            Set<String> keys = appStateMap.keySet();
            for (String key : keys) {
                ApplicationState appState = appStateMap.get(key);
                if (appState.getStateVersion() <= version) continue;
                if (reqdEndPointState == null) {
                    reqdEndPointState = new EndPointState(epState.getHeartBeatState());
                }
                reqdEndPointState.addApplicationState(key, appState);
            }
        }
        return reqdEndPointState;
    }

    synchronized void join(EndPoint from) {
        if (!from.equals(this.localEndPoint_)) {
            this.liveEndpoints_.add(from);
            this.unreachableEndpoints_.remove(from);
        }
    }

    void notifyFailureDetector(List<GossipDigest> gDigests) {
        IFailureDetector fd = FailureDetector.instance();
        for (GossipDigest gDigest : gDigests) {
            int localVersion;
            int remoteVersion;
            EndPointState localEndPointState = this.endPointStateMap_.get(gDigest.endPoint_);
            if (localEndPointState == null) continue;
            int remoteGeneration = gDigest.generation_;
            int localGeneration = this.endPointStateMap_.get((Object)gDigest.endPoint_).getHeartBeatState().generation_;
            if (remoteGeneration > localGeneration) {
                fd.report(gDigest.endPoint_);
                continue;
            }
            if (remoteGeneration != localGeneration || (remoteVersion = gDigest.maxVersion_) <= (localVersion = this.getMaxEndPointStateVersion(localEndPointState))) continue;
            fd.report(gDigest.endPoint_);
        }
    }

    void notifyFailureDetector(Map<EndPoint, EndPointState> remoteEpStateMap) {
        IFailureDetector fd = FailureDetector.instance();
        Set<EndPoint> endpoints = remoteEpStateMap.keySet();
        for (EndPoint endpoint : endpoints) {
            EndPointState remoteEndPointState = remoteEpStateMap.get(endpoint);
            EndPointState localEndPointState = this.endPointStateMap_.get(endpoint);
            if (localEndPointState == null) continue;
            int remoteGeneration = remoteEndPointState.getHeartBeatState().generation_;
            int localGeneration = localEndPointState.getHeartBeatState().generation_;
            if (remoteGeneration > localGeneration) {
                fd.report(endpoint);
                continue;
            }
            if (remoteGeneration != localGeneration) continue;
            int localVersion = this.getMaxEndPointStateVersion(localEndPointState);
            int remoteVersion = remoteEndPointState.getHeartBeatState().getHeartBeatVersion();
            if (remoteVersion <= localVersion) continue;
            fd.report(endpoint);
        }
    }

    void markAlive(EndPoint addr, EndPointState localState) {
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("marking as alive " + addr));
        }
        if (!localState.isAlive()) {
            this.isAlive(addr, localState, true);
            logger_.info((Object)("EndPoint " + addr + " is now UP"));
        }
    }

    private void handleNewJoin(EndPoint ep, EndPointState epState) {
        logger_.info((Object)("Node " + ep + " has now joined."));
        this.endPointStateMap_.put(ep, epState);
        this.isAlive(ep, epState, true);
        this.doNotifications(ep, epState);
    }

    synchronized void applyStateLocally(Map<EndPoint, EndPointState> epStateMap) {
        Set<EndPoint> eps = epStateMap.keySet();
        for (EndPoint ep : eps) {
            if (ep.equals(this.localEndPoint_)) continue;
            EndPointState localEpStatePtr = this.endPointStateMap_.get(ep);
            EndPointState remoteState = epStateMap.get(ep);
            if (localEpStatePtr != null) {
                int localGeneration = localEpStatePtr.getHeartBeatState().getGeneration();
                int remoteGeneration = remoteState.getHeartBeatState().getGeneration();
                if (remoteGeneration > localGeneration) {
                    this.handleNewJoin(ep, remoteState);
                    continue;
                }
                if (remoteGeneration != localGeneration) continue;
                int localMaxVersion = this.getMaxEndPointStateVersion(localEpStatePtr);
                int remoteMaxVersion = this.getMaxEndPointStateVersion(remoteState);
                if (remoteMaxVersion <= localMaxVersion) continue;
                this.markAlive(ep, localEpStatePtr);
                this.applyHeartBeatStateLocally(ep, localEpStatePtr, remoteState);
                this.applyApplicationStateLocally(ep, localEpStatePtr, remoteState);
                continue;
            }
            this.handleNewJoin(ep, remoteState);
        }
    }

    void applyHeartBeatStateLocally(EndPoint addr, EndPointState localState, EndPointState remoteState) {
        HeartBeatState localHbState = localState.getHeartBeatState();
        HeartBeatState remoteHbState = remoteState.getHeartBeatState();
        if (remoteHbState.getGeneration() > localHbState.getGeneration()) {
            this.markAlive(addr, localState);
            localState.setHeartBeatState(remoteHbState);
        }
        if (localHbState.getGeneration() == remoteHbState.getGeneration() && remoteHbState.getHeartBeatVersion() > localHbState.getHeartBeatVersion()) {
            int oldVersion = localHbState.getHeartBeatVersion();
            localState.setHeartBeatState(remoteHbState);
            if (logger_.isTraceEnabled()) {
                logger_.trace((Object)("Updating heartbeat state version to " + localState.getHeartBeatState().getHeartBeatVersion() + " from " + oldVersion + " for " + addr + " ..."));
            }
        }
    }

    void applyApplicationStateLocally(EndPoint addr, EndPointState localStatePtr, EndPointState remoteStatePtr) {
        Map<String, ApplicationState> localAppStateMap = localStatePtr.getApplicationState();
        Map<String, ApplicationState> remoteAppStateMap = remoteStatePtr.getApplicationState();
        Set<String> remoteKeys = remoteAppStateMap.keySet();
        for (String remoteKey : remoteKeys) {
            int localVersion;
            int remoteVersion;
            int localGeneration;
            ApplicationState remoteAppState = remoteAppStateMap.get(remoteKey);
            ApplicationState localAppState = localAppStateMap.get(remoteKey);
            if (localAppState == null) {
                localStatePtr.addApplicationState(remoteKey, remoteAppState);
                EndPointState deltaState = new EndPointState(localStatePtr.getHeartBeatState());
                deltaState.addApplicationState(remoteKey, remoteAppState);
                this.doNotifications(addr, deltaState);
                continue;
            }
            int remoteGeneration = remoteStatePtr.getHeartBeatState().getGeneration();
            if (remoteGeneration > (localGeneration = localStatePtr.getHeartBeatState().getGeneration())) {
                localStatePtr.addApplicationState(remoteKey, remoteAppState);
                EndPointState deltaState = new EndPointState(localStatePtr.getHeartBeatState());
                deltaState.addApplicationState(remoteKey, remoteAppState);
                this.doNotifications(addr, deltaState);
                continue;
            }
            if (remoteGeneration != localGeneration || (remoteVersion = remoteAppState.getStateVersion()) <= (localVersion = localAppState.getStateVersion())) continue;
            localStatePtr.addApplicationState(remoteKey, remoteAppState);
            EndPointState deltaState = new EndPointState(localStatePtr.getHeartBeatState());
            deltaState.addApplicationState(remoteKey, remoteAppState);
            this.doNotifications(addr, deltaState);
        }
    }

    void doNotifications(EndPoint addr, EndPointState epState) {
        for (IEndPointStateChangeSubscriber subscriber : this.subscribers_) {
            subscriber.onChange(addr, epState);
        }
    }

    synchronized void isAlive(EndPoint addr, EndPointState epState, boolean value) {
        epState.isAlive(value);
        if (value) {
            this.liveEndpoints_.add(addr);
            this.unreachableEndpoints_.remove(addr);
        } else {
            this.liveEndpoints_.remove(addr);
            this.unreachableEndpoints_.add(addr);
        }
        if (epState.isAGossiper()) {
            return;
        }
        epState.isAGossiper(true);
    }

    Map<EndPoint, GossipDigest> getEndPointGossipDigestMap(List<GossipDigest> gDigestList) {
        HashMap<EndPoint, GossipDigest> epMap = new HashMap<EndPoint, GossipDigest>();
        for (GossipDigest gDigest : gDigestList) {
            epMap.put(gDigest.getEndPoint(), gDigest);
        }
        return epMap;
    }

    EndPoint[] getEndPointsFromGossipDigest(List<GossipDigest> gDigestList) {
        HashSet<EndPoint> set = new HashSet<EndPoint>();
        for (GossipDigest gDigest : gDigestList) {
            set.add(gDigest.getEndPoint());
        }
        return set.toArray(new EndPoint[0]);
    }

    void requestAll(GossipDigest gDigest, List<GossipDigest> deltaGossipDigestList, int remoteGeneration) {
        deltaGossipDigestList.add(new GossipDigest(gDigest.getEndPoint(), remoteGeneration, 0));
    }

    void sendAll(GossipDigest gDigest, Map<EndPoint, EndPointState> deltaEpStateMap, int maxRemoteVersion) {
        EndPointState localEpStatePtr = this.getStateForVersionBiggerThan(gDigest.getEndPoint(), maxRemoteVersion);
        if (localEpStatePtr != null) {
            deltaEpStateMap.put(gDigest.getEndPoint(), localEpStatePtr);
        }
    }

    synchronized void examineGossiper(List<GossipDigest> gDigestList, List<GossipDigest> deltaGossipDigestList, Map<EndPoint, EndPointState> deltaEpStateMap) {
        for (GossipDigest gDigest : gDigestList) {
            int remoteGeneration = gDigest.getGeneration();
            int maxRemoteVersion = gDigest.getMaxVersion();
            EndPointState epStatePtr = this.endPointStateMap_.get(gDigest.getEndPoint());
            if (epStatePtr != null) {
                int localGeneration = epStatePtr.getHeartBeatState().getGeneration();
                int maxLocalVersion = this.getMaxEndPointStateVersion(epStatePtr);
                if (remoteGeneration == localGeneration && maxRemoteVersion == maxLocalVersion) continue;
                if (remoteGeneration > localGeneration) {
                    this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
                }
                if (remoteGeneration < localGeneration) {
                    this.sendAll(gDigest, deltaEpStateMap, 0);
                }
                if (remoteGeneration != localGeneration) continue;
                if (maxRemoteVersion > maxLocalVersion) {
                    deltaGossipDigestList.add(new GossipDigest(gDigest.getEndPoint(), remoteGeneration, maxLocalVersion));
                }
                if (maxRemoteVersion >= maxLocalVersion) continue;
                this.sendAll(gDigest, deltaEpStateMap, maxRemoteVersion);
                continue;
            }
            this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
        }
    }

    public void start(EndPoint localEndPoint, int generationNbr) throws IOException {
        this.localEndPoint_ = localEndPoint;
        Set<String> seedHosts = DatabaseDescriptor.getSeeds();
        for (String seedHost : seedHosts) {
            EndPoint seed = new EndPoint(InetAddress.getByName(seedHost).getHostAddress(), DatabaseDescriptor.getControlPort());
            if (seed.equals(localEndPoint)) continue;
            this.seeds_.add(seed);
        }
        EndPointState localState = this.endPointStateMap_.get(this.localEndPoint_);
        if (localState == null) {
            HeartBeatState hbState = new HeartBeatState(generationNbr, 0);
            localState = new EndPointState(hbState);
            localState.isAlive(true);
            localState.isAGossiper(true);
            this.endPointStateMap_.put(this.localEndPoint_, localState);
        }
        this.gossipTimer_.schedule((TimerTask)new GossipTimerTask(), 1000L, 1000L);
    }

    public synchronized void addApplicationState(String key, ApplicationState appState) {
        EndPointState epState = this.endPointStateMap_.get(this.localEndPoint_);
        if (epState != null) {
            epState.addApplicationState(key, appState);
        }
    }

    public synchronized void deleteApplicationState(String key) {
        EndPointState epState = this.endPointStateMap_.get(this.localEndPoint_);
        epState.deleteApplicationState(key);
    }

    public void stop() {
        this.gossipTimer_.cancel();
    }

    private class GossipTimerTask
    extends TimerTask {
        private GossipTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Gossiper gossiper = Gossiper.instance();
                synchronized (gossiper) {
                    Gossiper.this.endPointStateMap_.get(Gossiper.this.localEndPoint_).getHeartBeatState().updateHeartBeat();
                    ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>();
                    Gossiper.instance().makeRandomGossipDigest(gDigests);
                    if (gDigests.size() > 0) {
                        Message message = Gossiper.this.makeGossipDigestSynMessage(gDigests);
                        boolean bVal = Gossiper.this.doGossipToLiveMember(message);
                        Gossiper.this.doGossipToUnreachableMember(message);
                        if (!bVal) {
                            Gossiper.this.doGossipToSeed(message);
                        }
                        if (logger_.isTraceEnabled()) {
                            logger_.trace((Object)"Performing status check ...");
                        }
                        Gossiper.this.doStatusCheck();
                    }
                }
            }
            catch (Throwable th) {
                logger_.info((Object)LogUtil.throwableToString(th));
            }
        }
    }
}

