/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestSynMessage;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.log4j.Logger;

class GossipDigestSynVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(GossipDigestSynVerbHandler.class);

    GossipDigestSynVerbHandler() {
    }

    @Override
    public void doVerb(Message message) {
        EndPoint from = message.getFrom();
        if (logger_.isTraceEnabled()) {
            logger_.trace((Object)("Received a GossipDigestSynMessage from " + from));
        }
        byte[] bytes = message.getMessageBody();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            GossipDigestSynMessage gDigestMessage = GossipDigestSynMessage.serializer().deserialize(dis);
            if (!gDigestMessage.clusterId_.equals(DatabaseDescriptor.getClusterName())) {
                return;
            }
            List<GossipDigest> gDigestList = gDigestMessage.getGossipDigests();
            Gossiper.instance().notifyFailureDetector(gDigestList);
            this.doSort(gDigestList);
            ArrayList<GossipDigest> deltaGossipDigestList = new ArrayList<GossipDigest>();
            HashMap<EndPoint, EndPointState> deltaEpStateMap = new HashMap<EndPoint, EndPointState>();
            Gossiper.instance().examineGossiper(gDigestList, deltaGossipDigestList, deltaEpStateMap);
            GossipDigestAckMessage gDigestAck = new GossipDigestAckMessage(deltaGossipDigestList, deltaEpStateMap);
            Message gDigestAckMessage = Gossiper.instance().makeGossipDigestAckMessage(gDigestAck);
            if (logger_.isTraceEnabled()) {
                logger_.trace((Object)("Sending a GossipDigestAckMessage to " + from));
            }
            MessagingService.getMessagingInstance().sendUdpOneWay(gDigestAckMessage, from);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doSort(List<GossipDigest> gDigestList) {
        HashMap<EndPoint, GossipDigest> epToDigestMap = new HashMap<EndPoint, GossipDigest>();
        for (GossipDigest gDigest : gDigestList) {
            epToDigestMap.put(gDigest.getEndPoint(), gDigest);
        }
        ArrayList<GossipDigest> diffDigests = new ArrayList<GossipDigest>();
        for (GossipDigest gDigest : gDigestList) {
            EndPoint ep = gDigest.getEndPoint();
            EndPointState epState = Gossiper.instance().getEndPointStateForEndPoint(ep);
            int version = epState != null ? Gossiper.instance().getMaxEndPointStateVersion(epState) : 0;
            int diffVersion = Math.abs(version - gDigest.getMaxVersion());
            diffDigests.add(new GossipDigest(ep, gDigest.getGeneration(), diffVersion));
        }
        gDigestList.clear();
        Collections.sort(diffDigests);
        int size = diffDigests.size();
        for (int i = size - 1; i >= 0; --i) {
            gDigestList.add((GossipDigest)epToDigestMap.get(((GossipDigest)diffDigests.get(i)).getEndPoint()));
        }
    }
}

