/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.net.CompactEndPointSerializationHelper;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.utils.Log4jLogger;

class EndPointStatesSerializationHelper {
    private static Log4jLogger logger_ = new Log4jLogger(EndPointStatesSerializationHelper.class.getName());

    EndPointStatesSerializationHelper() {
    }

    static boolean serialize(Map<EndPoint, EndPointState> epStateMap, DataOutputStream dos) throws IOException {
        boolean bVal = true;
        int estimate = 0;
        int size = epStateMap.size();
        dos.writeInt(size);
        Set<EndPoint> eps = epStateMap.keySet();
        for (EndPoint ep : eps) {
            if (1428 - dos.size() < estimate) {
                logger_.info("@@@@ Breaking out to respect the MTU size in EPS. Estimate is " + estimate + " @@@@");
                bVal = false;
                break;
            }
            int pre = dos.size();
            CompactEndPointSerializationHelper.serialize(ep, dos);
            EndPointState epState = epStateMap.get(ep);
            EndPointState.serializer().serialize(epState, dos);
            int post = dos.size();
            estimate = post - pre;
        }
        return bVal;
    }

    static Map<EndPoint, EndPointState> deserialize(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        HashMap<EndPoint, EndPointState> epStateMap = new HashMap<EndPoint, EndPointState>();
        for (int i = 0; i < size; ++i) {
            if (dis.available() == 0) {
                logger_.info("Remaining bytes zero. Stopping deserialization in EndPointState.");
                break;
            }
            EndPoint ep = CompactEndPointSerializationHelper.deserialize(dis);
            EndPointState epState = EndPointState.serializer().deserialize(dis);
            epStateMap.put(ep, epState);
        }
        return epStateMap;
    }
}

