/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.BootstrapMetadata;
import org.apache.cassandra.dht.BootstrapMetadataMessage;
import org.apache.cassandra.dht.BootstrapSourceTarget;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.log4j.Logger;

class LeaveJoinProtocolHelper {
    private static Logger logger_ = Logger.getLogger(LeaveJoinProtocolHelper.class);

    LeaveJoinProtocolHelper() {
    }

    protected static Map<Range, List<Range>> getRangeSplitRangeMapping(Range[] oldRanges, Token[] allTokens) {
        HashMap<Range, List<Range>> splitRanges = new HashMap<Range, List<Range>>();
        Object[] tokens = new Token[allTokens.length];
        System.arraycopy(allTokens, 0, tokens, 0, tokens.length);
        Arrays.sort(tokens);
        Range prevRange = null;
        Object prevToken = null;
        boolean bVal = false;
        for (Range oldRange : oldRanges) {
            if (bVal) {
                bVal = false;
                List subRanges = (List)splitRanges.get(prevRange);
                if (subRanges != null) {
                    subRanges.add(new Range((Token)prevToken, prevRange.right()));
                }
            }
            prevRange = oldRange;
            prevToken = oldRange.left();
            for (Object token : tokens) {
                ArrayList<Range> subRanges = (ArrayList<Range>)splitRanges.get(oldRange);
                if (oldRange.contains((Token)token)) {
                    if (subRanges == null) {
                        subRanges = new ArrayList<Range>();
                        splitRanges.put(oldRange, subRanges);
                    }
                    subRanges.add(new Range((Token)prevToken, (Token)token));
                    prevToken = token;
                    bVal = true;
                    continue;
                }
                if (!bVal) continue;
                bVal = false;
                subRanges.add(new Range((Token)prevToken, oldRange.right()));
            }
        }
        if (bVal) {
            bVal = false;
            List subRanges = (List)splitRanges.get(prevRange);
            subRanges.add(new Range((Token)prevToken, prevRange.right()));
        }
        return splitRanges;
    }

    protected static Map<Range, List<BootstrapSourceTarget>> getRangeSourceTargetInfo(Map<Range, List<EndPoint>> oldRangeToEndPointMap, Map<Range, List<EndPoint>> newRangeToEndPointMap) {
        List<EndPoint> newEndPoints;
        List<EndPoint> oldEndPoints;
        HashMap<Range, List<BootstrapSourceTarget>> rangesWithSourceTarget = new HashMap<Range, List<BootstrapSourceTarget>>();
        Set<Range> oldRangeSet = oldRangeToEndPointMap.keySet();
        for (Range range : oldRangeSet) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Attempting to figure out the dudes who are bumped out for " + range + " ..."));
            }
            oldEndPoints = oldRangeToEndPointMap.get(range);
            newEndPoints = newRangeToEndPointMap.get(range);
            if (newEndPoints != null) {
                ArrayList<EndPoint> newEndPoints2 = new ArrayList<EndPoint>(newEndPoints);
                for (EndPoint newEndPoint : newEndPoints2) {
                    if (!oldEndPoints.contains(newEndPoint)) continue;
                    oldEndPoints.remove(newEndPoint);
                    newEndPoints.remove(newEndPoint);
                }
            } else {
                logger_.warn((Object)"Trespassing - scram");
            }
            if (!logger_.isDebugEnabled()) continue;
            logger_.debug((Object)("Done figuring out the dudes who are bumped out for range " + range + " ..."));
        }
        for (Range range : oldRangeSet) {
            oldEndPoints = oldRangeToEndPointMap.get(range);
            newEndPoints = newRangeToEndPointMap.get(range);
            ArrayList<BootstrapSourceTarget> srcTarget = (ArrayList<BootstrapSourceTarget>)rangesWithSourceTarget.get(range);
            if (srcTarget == null) {
                srcTarget = new ArrayList<BootstrapSourceTarget>();
                rangesWithSourceTarget.put(range, srcTarget);
            }
            int i = 0;
            for (EndPoint oldEndPoint : oldEndPoints) {
                srcTarget.add(new BootstrapSourceTarget(oldEndPoint, newEndPoints.get(i++)));
            }
        }
        return rangesWithSourceTarget;
    }

    protected static void assignWork(Map<Range, List<BootstrapSourceTarget>> rangesWithSourceTarget) throws IOException {
        Map<EndPoint, Map<EndPoint, List<Range>>> rangeInfo = LeaveJoinProtocolHelper.getWorkMap(rangesWithSourceTarget);
        LeaveJoinProtocolHelper.sendMessagesToBootstrapSources(rangeInfo);
    }

    protected static void assignWorkForLocalBootstrap(Map<Range, List<BootstrapSourceTarget>> rangesWithSourceTarget) throws IOException {
        Map<EndPoint, Map<EndPoint, List<Range>>> rangeInfo = LeaveJoinProtocolHelper.getWorkMap(rangesWithSourceTarget);
        Map<EndPoint, Map<EndPoint, List<Range>>> filteredRanges = LeaveJoinProtocolHelper.filterRangesForTargetEndPoint(rangeInfo, StorageService.getLocalStorageEndPoint());
        LeaveJoinProtocolHelper.sendMessagesToBootstrapSources(filteredRanges);
    }

    protected static Map<EndPoint, Map<EndPoint, List<Range>>> filterRangesForTargetEndPoint(Map<EndPoint, Map<EndPoint, List<Range>>> rangeInfo, EndPoint targetEndPoint) {
        HashMap<EndPoint, Map<EndPoint, List<Range>>> filteredMap = new HashMap<EndPoint, Map<EndPoint, List<Range>>>();
        for (Map.Entry<EndPoint, Map<EndPoint, List<Range>>> e : rangeInfo.entrySet()) {
            EndPoint source = e.getKey();
            Map<EndPoint, List<Range>> targets = e.getValue();
            HashMap<EndPoint, List<Range>> filteredTargets = new HashMap<EndPoint, List<Range>>();
            if (targets.get(targetEndPoint) != null) {
                filteredTargets.put(targetEndPoint, targets.get(targetEndPoint));
            }
            if (filteredTargets.size() <= 0) continue;
            filteredMap.put(source, filteredTargets);
        }
        return filteredMap;
    }

    private static void sendMessagesToBootstrapSources(Map<EndPoint, Map<EndPoint, List<Range>>> rangeInfo) throws IOException {
        Set<EndPoint> sources = rangeInfo.keySet();
        for (EndPoint source : sources) {
            Map<EndPoint, List<Range>> targetRangesMap = rangeInfo.get(source);
            Set<EndPoint> targets = targetRangesMap.keySet();
            ArrayList<BootstrapMetadata> bsmdList = new ArrayList<BootstrapMetadata>();
            for (EndPoint target : targets) {
                List<Range> rangeForTarget = targetRangesMap.get(target);
                BootstrapMetadata bsMetadata = new BootstrapMetadata(target, rangeForTarget);
                bsmdList.add(bsMetadata);
            }
            BootstrapMetadataMessage bsMetadataMessage = new BootstrapMetadataMessage(bsmdList.toArray(new BootstrapMetadata[0]));
            Message message = BootstrapMetadataMessage.makeBootstrapMetadataMessage(bsMetadataMessage);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Sending the BootstrapMetadataMessage to " + source));
            }
            MessagingService.getMessagingInstance().sendOneWay(message, source);
            StorageService.instance().addBootstrapSource(source);
        }
    }

    static Map<EndPoint, Map<EndPoint, List<Range>>> getWorkMap(Map<Range, List<BootstrapSourceTarget>> rangesWithSourceTarget) {
        HashMap<EndPoint, Map<EndPoint, List<Range>>> rangeInfo = new HashMap<EndPoint, Map<EndPoint, List<Range>>>();
        Set<Range> ranges = rangesWithSourceTarget.keySet();
        for (Range range : ranges) {
            List<BootstrapSourceTarget> rangeSourceTargets = rangesWithSourceTarget.get(range);
            for (BootstrapSourceTarget rangeSourceTarget : rangeSourceTargets) {
                ArrayList<Range> rangesToGive;
                HashMap<EndPoint, ArrayList<Range>> targetRangeMap = (HashMap<EndPoint, ArrayList<Range>>)rangeInfo.get(rangeSourceTarget.source_);
                if (targetRangeMap == null) {
                    targetRangeMap = new HashMap<EndPoint, ArrayList<Range>>();
                    rangeInfo.put(rangeSourceTarget.source_, targetRangeMap);
                }
                if ((rangesToGive = (ArrayList<Range>)targetRangeMap.get(rangeSourceTarget.target_)) == null) {
                    rangesToGive = new ArrayList<Range>();
                    targetRangeMap.put(rangeSourceTarget.target_, rangesToGive);
                }
                rangesToGive.add(range);
            }
        }
        return rangeInfo;
    }
}

