/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.MarshalException;

public class TimeUUIDType
extends AbstractType {
    @Override
    public int compare(byte[] o1, byte[] o2) {
        long t2;
        if (o1.length == 0) {
            return o2.length == 0 ? 0 : -1;
        }
        if (o2.length == 0) {
            return 1;
        }
        long t1 = LexicalUUIDType.getUUID(o1).timestamp();
        return t1 < (t2 = LexicalUUIDType.getUUID(o2).timestamp()) ? -1 : (t1 > t2 ? 1 : 0);
    }

    @Override
    public String getString(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        if (bytes.length != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        UUID uuid = LexicalUUIDType.getUUID(bytes);
        if (uuid.version() != 1) {
            throw new MarshalException("TimeUUID only makes sense with version 1 UUIDs");
        }
        return uuid.toString();
    }
}

