/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.filter.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.BufferedRandomAccessFile;
import org.apache.cassandra.io.IndexHelper;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.utils.BloomFilter;

public class SSTableNamesIterator
extends SimpleAbstractColumnIterator {
    private ColumnFamily cf;
    private Iterator<IColumn> iter;
    public final SortedSet<byte[]> columns;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableNamesIterator(SSTableReader ssTable, String key, SortedSet<byte[]> columnNames) throws IOException {
        assert (columnNames != null);
        this.columns = columnNames;
        String decoratedKey = ssTable.getPartitioner().decorateKey(key);
        long position = ssTable.getPosition(decoratedKey);
        if (position < 0L) {
            return;
        }
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(ssTable.getFilename(), "r", DatabaseDescriptor.getIndexedReadBufferSizeInKB() * 1024);
        try {
            file.seek(position);
            String keyInDisk = file.readUTF();
            assert (keyInDisk.equals(decoratedKey)) : keyInDisk;
            file.readInt();
            BloomFilter bf = IndexHelper.defreezeBloomFilter(file);
            ArrayList<byte[]> filteredColumnNames = new ArrayList<byte[]>(columnNames.size());
            for (byte[] name : columnNames) {
                if (!bf.isPresent(name)) continue;
                filteredColumnNames.add(name);
            }
            if (filteredColumnNames.isEmpty()) {
                return;
            }
            ArrayList<IndexHelper.IndexInfo> indexList = IndexHelper.deserializeIndex(file);
            this.cf = ColumnFamily.serializer().deserializeFromSSTableNoColumns(ssTable.makeColumnFamily(), file);
            file.readInt();
            AbstractType comparator = ssTable.getColumnComparator();
            TreeSet<IndexHelper.IndexInfo> ranges = new TreeSet<IndexHelper.IndexInfo>(IndexHelper.getComparator(comparator));
            for (byte[] name : filteredColumnNames) {
                int index = IndexHelper.indexFor(name, indexList, comparator, false);
                if (index == indexList.size()) continue;
                IndexHelper.IndexInfo indexInfo = (IndexHelper.IndexInfo)indexList.get(index);
                if (comparator.compare(name, indexInfo.firstName) < 0) continue;
                ranges.add(indexInfo);
            }
            long columnBegin = file.getFilePointer();
            for (IndexHelper.IndexInfo indexInfo : ranges) {
                file.seek(columnBegin + indexInfo.offset);
                while (file.getFilePointer() < columnBegin + indexInfo.offset + indexInfo.width) {
                    IColumn column = this.cf.getColumnSerializer().deserialize(file);
                    if (!columnNames.contains(column.name())) continue;
                    this.cf.addColumn(column);
                }
            }
        }
        finally {
            file.close();
        }
        this.iter = this.cf.getSortedColumns().iterator();
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.cf;
    }

    protected IColumn computeNext() {
        if (this.iter == null || !this.iter.hasNext()) {
            return (IColumn)this.endOfData();
        }
        return this.iter.next();
    }
}

