/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SSTableNamesIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.SSTableReader;

public class NamesQueryFilter
extends QueryFilter {
    public final SortedSet<byte[]> columns;

    public NamesQueryFilter(String key, QueryPath columnParent, SortedSet<byte[]> columns) {
        super(key, columnParent);
        this.columns = columns;
    }

    public NamesQueryFilter(String key, QueryPath columnParent, byte[] column) {
        this(key, columnParent, NamesQueryFilter.getSingleColumnSet(column));
    }

    private static TreeSet<byte[]> getSingleColumnSet(byte[] column) {
        Comparator<byte[]> singleColumnComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return Arrays.equals(o1, o2) ? 0 : -1;
            }
        };
        TreeSet<byte[]> set = new TreeSet<byte[]>(singleColumnComparator);
        set.add(column);
        return set;
    }

    @Override
    public ColumnIterator getMemColumnIterator(Memtable memtable, AbstractType comparator) {
        return memtable.getNamesIterator(this);
    }

    @Override
    public ColumnIterator getSSTableColumnIterator(SSTableReader sstable) throws IOException {
        return new SSTableNamesIterator(sstable, this.key, this.columns);
    }

    @Override
    public SuperColumn filterSuperColumn(SuperColumn superColumn, int gcBefore) {
        for (IColumn column : superColumn.getSubColumns()) {
            if (this.columns.contains(column.name())) continue;
            superColumn.remove(column.name());
        }
        return superColumn;
    }

    @Override
    public void collectReducedColumns(IColumnContainer container, Iterator<IColumn> reducedColumns, int gcBefore) {
        while (reducedColumns.hasNext()) {
            IColumn column = reducedColumns.next();
            if (column.isMarkedForDelete() && column.getLocalDeletionTime() <= gcBefore) continue;
            container.addColumn(column);
        }
    }
}

