/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.IdentityQueryFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BasicUtilities;
import org.apache.log4j.Logger;

public class SystemTable {
    private static Logger logger = Logger.getLogger(SystemTable.class);
    public static final String LOCATION_CF = "LocationInfo";
    private static final String LOCATION_KEY = "L";
    private static final byte[] TOKEN = SystemTable.utf8("Token");
    private static final byte[] GENERATION = SystemTable.utf8("Generation");
    private static StorageMetadata metadata;

    private static byte[] utf8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void updateToken(Token token) throws IOException {
        assert (metadata != null);
        IPartitioner p = StorageService.getPartitioner();
        Table table = Table.open("system");
        NamesQueryFilter filter = new NamesQueryFilter(LOCATION_KEY, new QueryPath(LOCATION_CF), TOKEN);
        ColumnFamily cf = table.getColumnFamilyStore(LOCATION_CF).getColumnFamily(filter);
        long oldTokenColumnTimestamp = cf.getColumn(TOKEN).timestamp();
        Column tokenColumn = new Column(TOKEN, p.getTokenFactory().toByteArray(token), oldTokenColumnTimestamp + 1L);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Replacing old token " + p.getTokenFactory().fromByteArray(cf.getColumn(TOKEN).value()) + " with " + token));
        }
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        cf.addColumn(tokenColumn);
        rm.add(cf);
        rm.apply();
        metadata.setToken(token);
    }

    public static synchronized StorageMetadata initMetadata() throws IOException {
        if (metadata != null) {
            return metadata;
        }
        Table table = Table.open("system");
        IdentityQueryFilter filter = new IdentityQueryFilter(LOCATION_KEY, new QueryPath(LOCATION_CF));
        ColumnFamily cf = table.getColumnFamilyStore(LOCATION_CF).getColumnFamily(filter);
        IPartitioner p = StorageService.getPartitioner();
        if (cf == null) {
            Object token = p.getDefaultToken();
            logger.info((Object)("Saved Token not found. Using " + token));
            int generation = 1;
            RowMutation rm = new RowMutation("system", LOCATION_KEY);
            cf = ColumnFamily.create("system", LOCATION_CF);
            cf.addColumn(new Column(TOKEN, p.getTokenFactory().toByteArray(token)));
            cf.addColumn(new Column(GENERATION, BasicUtilities.intToByteArray(generation)));
            rm.add(cf);
            rm.apply();
            metadata = new StorageMetadata((Token)token, generation);
            return metadata;
        }
        IColumn tokenColumn = cf.getColumn(TOKEN);
        Token token = p.getTokenFactory().fromByteArray(tokenColumn.value());
        logger.info((Object)("Saved Token found: " + token));
        IColumn generation = cf.getColumn(GENERATION);
        int gen = BasicUtilities.byteArrayToInt(generation.value()) + 1;
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        cf = ColumnFamily.create("system", LOCATION_CF);
        Column generation2 = new Column(GENERATION, BasicUtilities.intToByteArray(gen), generation.timestamp() + 1L);
        cf.addColumn(generation2);
        rm.add(cf);
        rm.apply();
        metadata = new StorageMetadata(token, gen);
        return metadata;
    }

    public static class StorageMetadata {
        private Token token;
        private int generation;

        StorageMetadata(Token storageId, int generation) {
            this.token = storageId;
            this.generation = generation;
        }

        public Token getToken() {
            return this.token;
        }

        public void setToken(Token storageId) {
            this.token = storageId;
        }

        public int getGeneration() {
            return this.generation;
        }
    }
}

