/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadCommandSerializer;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;

class SliceFromReadCommandSerializer
extends ReadCommandSerializer {
    SliceFromReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand rm, DataOutputStream dos) throws IOException {
        SliceFromReadCommand realRM = (SliceFromReadCommand)rm;
        dos.writeBoolean(realRM.isDigestQuery());
        dos.writeUTF(realRM.table);
        dos.writeUTF(realRM.key);
        realRM.queryPath.serialize(dos);
        ColumnSerializer.writeName(realRM.start, dos);
        ColumnSerializer.writeName(realRM.finish, dos);
        dos.writeBoolean(realRM.reversed);
        dos.writeInt(realRM.count);
    }

    @Override
    public ReadCommand deserialize(DataInputStream dis) throws IOException {
        boolean isDigest = dis.readBoolean();
        SliceFromReadCommand rm = new SliceFromReadCommand(dis.readUTF(), dis.readUTF(), QueryPath.deserialize(dis), ColumnSerializer.readName(dis), ColumnSerializer.readName(dis), dis.readBoolean(), dis.readInt());
        rm.setDigestQuery(isDigest);
        return rm;
    }
}

