/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.ICompactSerializer;

class RowSerializer
implements ICompactSerializer<Row> {
    RowSerializer() {
    }

    @Override
    public void serialize(Row row, DataOutputStream dos) throws IOException {
        dos.writeUTF(row.getTable());
        dos.writeUTF(row.key());
        Collection<ColumnFamily> columnFamilies = row.getColumnFamilies();
        int size = columnFamilies.size();
        dos.writeInt(size);
        for (ColumnFamily cf : columnFamilies) {
            ColumnFamily.serializer().serialize(cf, (DataOutput)dos);
        }
    }

    @Override
    public Row deserialize(DataInputStream dis) throws IOException {
        String table = dis.readUTF();
        String key = dis.readUTF();
        Row row = new Row(table, key);
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            ColumnFamily cf = ColumnFamily.serializer().deserialize(dis);
            row.addColumnFamily(cf);
        }
        return row;
    }
}

