/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.log4j.Logger;

public class RowMutationVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(RowMutationVerbHandler.class);
    private static ThreadLocal<RowMutationContext> tls_ = new InheritableThreadLocal<RowMutationContext>();

    @Override
    public void doVerb(Message message) {
        byte[] bytes = message.getMessageBody();
        RowMutationContext rowMutationCtx = tls_.get();
        if (rowMutationCtx == null) {
            rowMutationCtx = new RowMutationContext();
            tls_.set(rowMutationCtx);
        }
        rowMutationCtx.buffer_.reset(bytes, bytes.length);
        try {
            byte[] hintedBytes;
            RowMutation rm = RowMutation.serializer().deserialize(rowMutationCtx.buffer_);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Applying " + rm));
            }
            if ((hintedBytes = message.getHeader("HINT")) != null && hintedBytes.length > 0) {
                EndPoint hint = EndPoint.fromBytes(hintedBytes);
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Adding hint for " + hint));
                }
                RowMutation hintedMutation = new RowMutation("system", rm.table());
                hintedMutation.addHints(rm.key(), hint.getHost());
                hintedMutation.apply();
            }
            rowMutationCtx.row_.clear();
            rowMutationCtx.row_.setTable(rm.table());
            rowMutationCtx.row_.setKey(rm.key());
            rm.apply(rowMutationCtx.row_);
            WriteResponse response = new WriteResponse(rm.table(), rm.key(), true);
            Message responseMessage = WriteResponse.makeWriteResponseMessage(message, response);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)(rm + " applied.  Sending response to " + message.getMessageId() + "@" + message.getFrom()));
            }
            MessagingService.getMessagingInstance().sendOneWay(responseMessage, message.getFrom());
        }
        catch (IOException e) {
            logger_.error((Object)"Error in row mutation", (Throwable)e);
        }
    }

    protected static class RowMutationContext {
        protected Row row_ = new Row();
        protected DataInputBuffer buffer_ = new DataInputBuffer();

        protected RowMutationContext() {
        }
    }
}

