/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.commons.lang.StringUtils;

public class RangeReply {
    public final List<String> keys;
    public final boolean rangeCompletedLocally;

    public RangeReply(List<String> keys, boolean rangeCompletedLocally) {
        this.keys = keys;
        this.rangeCompletedLocally = rangeCompletedLocally;
    }

    public Message getReply(Message originalMessage) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        dob.writeBoolean(this.rangeCompletedLocally);
        for (String key : this.keys) {
            dob.writeUTF(key);
        }
        byte[] data = Arrays.copyOf(dob.getData(), dob.getLength());
        return originalMessage.getReply(StorageService.getLocalStorageEndPoint(), data);
    }

    public String toString() {
        return "RangeReply(keys=[" + StringUtils.join(this.keys, (String)", ") + "], completed=" + this.rangeCompletedLocally + ')';
    }

    public static RangeReply read(byte[] body) throws IOException {
        DataInputBuffer bufIn = new DataInputBuffer();
        bufIn.reset(body, body.length);
        boolean rangeCompletedLocally = bufIn.readBoolean();
        ArrayList<String> keys = new ArrayList<String>();
        while (bufIn.getPosition() < body.length) {
            keys.add(bufIn.readUTF());
        }
        return new RangeReply(keys, rangeCompletedLocally);
    }
}

