/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.net.EndPoint;
import org.apache.log4j.Logger;

class MinorCompactionManager {
    private static MinorCompactionManager instance_;
    private static Lock lock_;
    private static Logger logger_;
    static final int MINCOMPACTION_THRESHOLD = 4;
    static final int MAXCOMPACTION_THRESHOLD = 32;
    private ExecutorService compactor_ = new DebuggableThreadPoolExecutor("MINOR-COMPACTION-POOL");

    MinorCompactionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MinorCompactionManager instance() {
        if (instance_ == null) {
            lock_.lock();
            try {
                if (instance_ == null) {
                    instance_ = new MinorCompactionManager();
                }
            }
            finally {
                lock_.unlock();
            }
        }
        return instance_;
    }

    public Future<Integer> submit(ColumnFamilyStore columnFamilyStore) {
        return this.submit(columnFamilyStore, 4, 32);
    }

    Future<Integer> submit(final ColumnFamilyStore columnFamilyStore, final int minThreshold, final int maxThreshold) {
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws IOException {
                return columnFamilyStore.doCompaction(minThreshold, maxThreshold);
            }
        };
        return this.compactor_.submit(callable);
    }

    public void submitCleanup(ColumnFamilyStore columnFamilyStore) {
        this.compactor_.submit(new CleanupCompactor(columnFamilyStore));
    }

    public Future<Boolean> submit(ColumnFamilyStore columnFamilyStore, List<Range> ranges, EndPoint target, List<String> fileList) {
        return this.compactor_.submit(new FileCompactor2(columnFamilyStore, ranges, target, fileList));
    }

    public void submitMajor(ColumnFamilyStore columnFamilyStore, long skip) {
        this.compactor_.submit(new OnDemandCompactor(columnFamilyStore, skip));
    }

    static {
        lock_ = new ReentrantLock();
        logger_ = Logger.getLogger(MinorCompactionManager.class);
    }

    static class CleanupCompactor
    implements Runnable {
        private ColumnFamilyStore columnFamilyStore_;

        CleanupCompactor(ColumnFamilyStore columnFamilyStore) {
            this.columnFamilyStore_ = columnFamilyStore;
        }

        @Override
        public void run() {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Started  compaction ..." + this.columnFamilyStore_.columnFamily_));
            }
            try {
                this.columnFamilyStore_.doCleanupCompaction();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Finished compaction ..." + this.columnFamilyStore_.columnFamily_));
            }
        }
    }

    static class OnDemandCompactor
    implements Runnable {
        private ColumnFamilyStore columnFamilyStore_;
        private long skip_ = 0L;

        OnDemandCompactor(ColumnFamilyStore columnFamilyStore, long skip) {
            this.columnFamilyStore_ = columnFamilyStore;
            this.skip_ = skip;
        }

        @Override
        public void run() {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Started  Major compaction for " + this.columnFamilyStore_.columnFamily_));
            }
            try {
                this.columnFamilyStore_.doMajorCompaction(this.skip_);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Finished Major compaction for " + this.columnFamilyStore_.columnFamily_));
            }
        }
    }

    static class FileCompactor2
    implements Callable<Boolean> {
        private ColumnFamilyStore columnFamilyStore_;
        private List<Range> ranges_;
        private EndPoint target_;
        private List<String> fileList_;

        FileCompactor2(ColumnFamilyStore columnFamilyStore, List<Range> ranges, EndPoint target, List<String> fileList) {
            this.columnFamilyStore_ = columnFamilyStore;
            this.ranges_ = ranges;
            this.target_ = target;
            this.fileList_ = fileList;
        }

        @Override
        public Boolean call() {
            boolean result;
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Started  compaction ..." + this.columnFamilyStore_.columnFamily_));
            }
            try {
                result = this.columnFamilyStore_.doAntiCompaction(this.ranges_, this.target_, this.fileList_);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Finished compaction ..." + this.columnFamilyStore_.columnFamily_));
            }
            return result;
        }
    }
}

