/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.log4j.Logger;

public class DataFileVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(DataFileVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        byte[] bytes = message.getMessageBody();
        String table = new String(bytes);
        logger_.info((Object)("**** Received a request from " + message.getFrom()));
        try {
            List<SSTableReader> ssTables = Table.open(table).getAllSSTablesOnDisk();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(ssTables.size());
            for (SSTableReader sstable : ssTables) {
                dos.writeUTF(sstable.getFilename());
            }
            Message response = message.getReply(StorageService.getLocalStorageEndPoint(), bos.toByteArray());
            MessagingService.getMessagingInstance().sendOneWay(response, message.getFrom());
        }
        catch (IOException ex) {
            logger_.error((Object)"Error listing data files", (Throwable)ex);
        }
    }
}

