/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.ThreadFactoryImpl;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BinaryMemtable;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.CommitLog;
import org.apache.cassandra.db.FileNameComparator;
import org.apache.cassandra.db.FileStructComparator;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.MinorCompactionManager;
import org.apache.cassandra.db.PeriodicFlushManager;
import org.apache.cassandra.db.RangeReply;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.cassandra.io.FileStruct;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FileUtils;
import org.apache.cassandra.utils.LogUtil;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.cassandra.utils.TimedStatsDeque;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public final class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static Logger logger_ = Logger.getLogger(ColumnFamilyStore.class);
    private static final int BUFSIZE = 0x8000000;
    private static NonBlockingHashMap<String, Set<Memtable>> memtablesPendingFlush = new NonBlockingHashMap();
    private static ExecutorService flusher_ = new DebuggableThreadPoolExecutor(DatabaseDescriptor.getFlushMinThreads(), DatabaseDescriptor.getFlushMaxThreads(), Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("MEMTABLE-FLUSHER-POOL"));
    private final String table_;
    public final String columnFamily_;
    private final boolean isSuper_;
    private volatile Integer memtableSwitchCount = 0;
    private AtomicInteger fileIndexGenerator_ = new AtomicInteger(0);
    private Memtable memtable_;
    private ReentrantReadWriteLock memtableLock_ = new ReentrantReadWriteLock(true);
    private AtomicReference<BinaryMemtable> binaryMemtable_;
    private SortedMap<String, SSTableReader> ssTables_ = new TreeMap<String, SSTableReader>(new FileNameComparator(1));
    private ReentrantReadWriteLock sstableLock_ = new ReentrantReadWriteLock(true);
    private TimedStatsDeque readStats_ = new TimedStatsDeque(60000L);
    private TimedStatsDeque writeStats_ = new TimedStatsDeque(60000L);

    ColumnFamilyStore(String table, String columnFamilyName, boolean isSuper, int indexValue) throws IOException {
        this.table_ = table;
        this.columnFamily_ = columnFamilyName;
        this.isSuper_ = isSuper;
        this.fileIndexGenerator_.set(indexValue);
        this.memtable_ = new Memtable(this.table_, this.columnFamily_);
        this.binaryMemtable_ = new AtomicReference<BinaryMemtable>(new BinaryMemtable(this.table_, this.columnFamily_));
    }

    public static ColumnFamilyStore getColumnFamilyStore(String table, String columnFamily) throws IOException {
        String[] dataFileDirectories;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String directory : dataFileDirectories = DatabaseDescriptor.getAllDataFileLocationsForTable(table)) {
            File[] files;
            File fileDir = new File(directory);
            for (File file : files = fileDir.listFiles()) {
                String filename = file.getName();
                String cfName = ColumnFamilyStore.getColumnFamilyFromFileName(filename);
                if (!cfName.equals(columnFamily)) continue;
                int index = ColumnFamilyStore.getIndexFromFileName(filename);
                indices.add(index);
            }
        }
        Collections.sort(indices);
        int value = indices.size() > 0 ? (Integer)indices.get(indices.size() - 1) : 0;
        ColumnFamilyStore cfs = new ColumnFamilyStore(table, columnFamily, "Super".equals(DatabaseDescriptor.getColumnType(table, columnFamily)), value);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(cfs, new ObjectName("org.apache.cassandra.db:type=ColumnFamilyStores,name=" + table + ",columnfamily=" + columnFamily));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cfs;
    }

    void onStart() throws IOException {
        int flushPeriod;
        String[] dataFileDirectories;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Starting CFS " + this.columnFamily_));
        }
        ArrayList<File> sstableFiles = new ArrayList<File>();
        for (String directory : dataFileDirectories = DatabaseDescriptor.getAllDataFileLocationsForTable(this.table_)) {
            File[] files;
            File fileDir = new File(directory);
            for (File file : files = fileDir.listFiles()) {
                String filename = file.getName();
                if ((file.length() == 0L || filename.contains("-tmp")) && filename.contains(this.columnFamily_)) {
                    file.delete();
                    continue;
                }
                String cfName = ColumnFamilyStore.getColumnFamilyFromFileName(filename);
                if (!cfName.equals(this.columnFamily_) || !filename.contains("-Data.db")) continue;
                sstableFiles.add(file.getAbsoluteFile());
            }
        }
        Collections.sort(sstableFiles, new FileUtils.FileComparator());
        for (File file : sstableFiles) {
            SSTableReader sstable;
            String filename = file.getAbsolutePath();
            try {
                sstable = SSTableReader.open(filename);
            }
            catch (IOException ex) {
                logger_.error((Object)("Corrupt file " + filename + "; skipped"), (Throwable)ex);
                continue;
            }
            this.ssTables_.put(filename, sstable);
        }
        MinorCompactionManager.instance().submit(this);
        if (this.table_.equals("system") && this.columnFamily_.equals("HintsColumnFamily")) {
            HintedHandOffManager.instance().submit(this);
        }
        if ((flushPeriod = DatabaseDescriptor.getFlushPeriod(this.table_, this.columnFamily_)) > 0) {
            PeriodicFlushManager.instance().submitPeriodicFlusher(this, flushPeriod);
        }
    }

    public String cfStats(String newLineSeparator) {
        StringBuilder sb = new StringBuilder();
        if (this.ssTables_.size() == 0) {
            return sb.toString();
        }
        sb.append(this.columnFamily_ + " statistics :");
        sb.append(newLineSeparator);
        sb.append("Number of files on disk : " + this.ssTables_.size());
        sb.append(newLineSeparator);
        double totalSpace = 0.0;
        for (SSTableReader sstable : this.ssTables_.values()) {
            File f = new File(sstable.getFilename());
            totalSpace += (double)f.length();
        }
        String diskSpace = FileUtils.stringifyFileSize(totalSpace);
        sb.append("Total disk space : " + diskSpace);
        sb.append(newLineSeparator);
        sb.append("--------------------------------------");
        sb.append(newLineSeparator);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToList(SSTableReader file) {
        this.sstableLock_.writeLock().lock();
        try {
            this.ssTables_.put(file.getFilename(), file);
        }
        finally {
            this.sstableLock_.writeLock().unlock();
        }
    }

    boolean forceCompaction(List<Range> ranges, EndPoint target, long skip, List<String> fileList) {
        boolean result;
        block8: {
            Future<Boolean> futurePtr = null;
            if (ranges != null) {
                futurePtr = MinorCompactionManager.instance().submit(this, ranges, target, fileList);
            } else {
                MinorCompactionManager.instance().submitMajor(this, skip);
            }
            result = true;
            try {
                if (futurePtr != null) {
                    result = futurePtr.get();
                }
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)"Done forcing compaction ...");
                }
            }
            catch (ExecutionException ex) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)LogUtil.throwableToString(ex));
                }
            }
            catch (InterruptedException ex2) {
                if (!logger_.isDebugEnabled()) break block8;
                logger_.debug((Object)LogUtil.throwableToString(ex2));
            }
        }
        return result;
    }

    @Override
    public String getColumnFamilyName() {
        return this.columnFamily_;
    }

    private static String getColumnFamilyFromFileName(String filename) {
        return filename.split("-")[0];
    }

    protected static int getIndexFromFileName(String filename) {
        StringTokenizer st = new StringTokenizer(filename, "-");
        int count = st.countTokens();
        int i = 0;
        String index = null;
        while (st.hasMoreElements()) {
            index = (String)st.nextElement();
            if (i == count - 2) break;
            ++i;
        }
        return Integer.parseInt(index);
    }

    String getTempSSTablePath() {
        String fname = this.getTempSSTableFileName();
        return new File(DatabaseDescriptor.getDataFileLocationForTable(this.table_), fname).getAbsolutePath();
    }

    String getTempSSTableFileName() {
        return String.format("%s-%s-%s-Data.db", this.columnFamily_, "tmp", this.fileIndexGenerator_.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchMemtable(Memtable oldMemtable, CommitLog.CommitLogContext ctx) {
        this.memtableLock_.writeLock().lock();
        try {
            if (oldMemtable.isFrozen()) {
                return;
            }
            logger_.info((Object)(this.columnFamily_ + " has reached its threshold; switching in a fresh Memtable"));
            oldMemtable.freeze();
            ColumnFamilyStore.getMemtablesPendingFlushNotNull(this.columnFamily_).add(oldMemtable);
            ColumnFamilyStore.submitFlush(oldMemtable, ctx);
            this.memtable_ = new Memtable(this.table_, this.columnFamily_);
        }
        finally {
            this.memtableLock_.writeLock().unlock();
        }
        if (this.memtableSwitchCount == Integer.MAX_VALUE) {
            this.memtableSwitchCount = 0;
        }
        Integer n = this.memtableSwitchCount;
        Integer n2 = this.memtableSwitchCount = Integer.valueOf(this.memtableSwitchCount + 1);
    }

    void switchBinaryMemtable(String key, byte[] buffer) throws IOException {
        this.binaryMemtable_.set(new BinaryMemtable(this.table_, this.columnFamily_));
        this.binaryMemtable_.get().put(key, buffer);
    }

    @Override
    public void forceFlush() {
        if (this.memtable_.isClean()) {
            return;
        }
        CommitLog.CommitLogContext ctx = null;
        try {
            ctx = CommitLog.open().getContext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.switchMemtable(this.memtable_, ctx);
    }

    void forceBlockingFlush() throws IOException, ExecutionException, InterruptedException {
        this.forceFlush();
        Future<?> f = flusher_.submit(new Runnable(){

            @Override
            public void run() {
            }
        });
        f.get();
    }

    public void forceFlushBinary() {
        ColumnFamilyStore.submitFlush(this.binaryMemtable_.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(String key, ColumnFamily columnFamily, CommitLog.CommitLogContext cLogCtx) throws IOException {
        long start = System.currentTimeMillis();
        Memtable initialMemtable = this.getMemtableThreadSafe();
        if (initialMemtable.isThresholdViolated()) {
            this.switchMemtable(initialMemtable, cLogCtx);
        }
        this.memtableLock_.writeLock().lock();
        try {
            this.memtable_.put(key, columnFamily);
        }
        finally {
            this.memtableLock_.writeLock().unlock();
        }
        this.writeStats_.add(System.currentTimeMillis() - start);
    }

    void applyBinary(String key, byte[] buffer) throws IOException {
        long start = System.currentTimeMillis();
        this.binaryMemtable_.get().put(key, buffer);
        this.writeStats_.add(System.currentTimeMillis() - start);
    }

    private static void merge(List<ColumnFamily> columnFamilies) {
        ColumnFamily cf = ColumnFamily.resolve(columnFamilies);
        columnFamilies.clear();
        columnFamilies.add(cf);
    }

    private static ColumnFamily resolveAndRemoveDeleted(List<ColumnFamily> columnFamilies) {
        ColumnFamily cf = ColumnFamily.resolve(columnFamilies);
        return ColumnFamilyStore.removeDeleted(cf);
    }

    static ColumnFamily removeDeleted(ColumnFamily cf) {
        return ColumnFamilyStore.removeDeleted(cf, ColumnFamilyStore.getDefaultGCBefore());
    }

    public static int getDefaultGCBefore() {
        return (int)(System.currentTimeMillis() / 1000L) - DatabaseDescriptor.getGcGraceInSeconds();
    }

    static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore) {
        if (cf == null) {
            return null;
        }
        for (byte[] cname : cf.getColumnNames()) {
            IColumn c = cf.getColumnsMap().get(cname);
            if (c instanceof SuperColumn) {
                long minTimestamp = Math.max(c.getMarkedForDeleteAt(), cf.getMarkedForDeleteAt());
                cf.remove(cname);
                SuperColumn sc = ((SuperColumn)c).cloneMeShallow();
                for (IColumn subColumn : c.getSubColumns()) {
                    if (subColumn.timestamp() <= minTimestamp || subColumn.isMarkedForDelete() && subColumn.getLocalDeletionTime() <= gcBefore) continue;
                    sc.addColumn(subColumn);
                }
                if (sc.getSubColumns().size() <= 0 && sc.getLocalDeletionTime() <= gcBefore) continue;
                cf.addColumn(sc);
                continue;
            }
            if ((!c.isMarkedForDelete() || c.getLocalDeletionTime() > gcBefore) && c.timestamp() > cf.getMarkedForDeleteAt()) continue;
            cf.remove(cname);
        }
        if (cf.getColumnCount() == 0 && cf.getLocalDeletionTime() <= gcBefore) {
            return null;
        }
        return cf;
    }

    void applyNow(String key, ColumnFamily columnFamily) throws IOException {
        this.getMemtableThreadSafe().put(key, columnFamily);
    }

    void onMemtableFlush(CommitLog.CommitLogContext cLogCtx) throws IOException {
        if (cLogCtx.isValidContext()) {
            CommitLog.open().onMemtableFlush(this.table_, this.columnFamily_, cLogCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeLocation(SSTableReader sstable) {
        int ssTableCount;
        this.sstableLock_.writeLock().lock();
        try {
            this.ssTables_.put(sstable.getFilename(), sstable);
            ssTableCount = this.ssTables_.size();
        }
        finally {
            this.sstableLock_.writeLock().unlock();
        }
        if (ssTableCount >= 4) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Submitting " + this.columnFamily_ + " for compaction"));
            }
            MinorCompactionManager.instance().submit(this);
        }
    }

    private PriorityQueue<FileStruct> initializePriorityQueue(List<String> files, List<Range> ranges) throws IOException {
        PriorityQueue<FileStruct> pq = new PriorityQueue<FileStruct>();
        if (files.size() > 1 || ranges != null && files.size() > 0) {
            FileStruct fs = null;
            for (String file : files) {
                fs = SSTableReader.get(file).getFileStruct();
                fs.advance(true);
                if (fs.isExhausted()) continue;
                pq.add(fs);
            }
        }
        return pq;
    }

    static Set<List<String>> getCompactionBuckets(Iterable<String> files, long min) {
        ConcurrentHashMap<List, Long> buckets = new ConcurrentHashMap<List, Long>();
        for (String fname : files) {
            File f = new File(fname);
            long size = f.length();
            boolean bFound = false;
            for (List bucket : buckets.keySet()) {
                long averageSize = (Long)buckets.get(bucket);
                if ((size <= averageSize / 2L || size >= 3L * averageSize / 2L) && (size >= min || averageSize >= min)) continue;
                buckets.remove(bucket);
                averageSize = (averageSize + size) / 2L;
                bucket.add(fname);
                buckets.put(bucket, averageSize);
                bFound = true;
                break;
            }
            if (bFound) continue;
            ArrayList<String> bucket = new ArrayList<String>();
            bucket.add(fname);
            buckets.put(bucket, size);
        }
        return buckets.keySet();
    }

    int doCompaction(int minThreshold, int maxThreshold) throws IOException {
        int filesCompacted = 0;
        for (List<String> files : ColumnFamilyStore.getCompactionBuckets(this.ssTables_.keySet(), 0x3200000L)) {
            if (files.size() < minThreshold) continue;
            Collections.sort(files, new FileNameComparator(0));
            filesCompacted += this.doFileCompaction(files.subList(0, Math.min(files.size(), maxThreshold)), 0x8000000);
        }
        return filesCompacted;
    }

    void doMajorCompaction(long skip) throws IOException {
        this.doMajorCompactionInternal(skip);
    }

    void doMajorCompactionInternal(long skip) throws IOException {
        ArrayList<String> files;
        ArrayList<String> filesInternal = new ArrayList<String>(this.ssTables_.keySet());
        if (skip > 0L) {
            files = new ArrayList();
            for (String file : filesInternal) {
                File f = new File(file);
                if (f.length() >= skip * 1024L * 1024L * 1024L) continue;
                files.add(file);
            }
        } else {
            files = filesInternal;
        }
        this.doFileCompaction(files, 0x8000000);
    }

    long getExpectedCompactedFileSize(List<String> files) {
        long expectedFileSize = 0L;
        for (String file : files) {
            File f = new File(file);
            long size = f.length();
            expectedFileSize += size;
        }
        return expectedFileSize;
    }

    String getMaxSizeFile(List<String> files) {
        long maxSize = 0L;
        String maxFile = null;
        for (String file : files) {
            File f = new File(file);
            if (f.length() <= maxSize) continue;
            maxSize = f.length();
            maxFile = file;
        }
        return maxFile;
    }

    boolean doAntiCompaction(List<Range> ranges, EndPoint target, List<String> fileList) throws IOException {
        ArrayList<String> files = new ArrayList<String>(this.ssTables_.keySet());
        return this.doFileAntiCompaction(files, ranges, target, fileList);
    }

    void forceCleanup() {
        MinorCompactionManager.instance().submitCleanup(this);
    }

    void doCleanupCompaction() throws IOException {
        ArrayList<String> files = new ArrayList<String>(this.ssTables_.keySet());
        for (String file : files) {
            this.doCleanup(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCleanup(String file) throws IOException {
        if (file == null) {
            return;
        }
        ArrayList<String> files = new ArrayList<String>();
        files.add(file);
        ArrayList<String> newFiles = new ArrayList<String>();
        Map<EndPoint, List<Range>> endPointtoRangeMap = StorageService.instance().constructEndPointToRangesMap();
        List<Range> myRanges = endPointtoRangeMap.get(StorageService.getLocalStorageEndPoint());
        this.doFileAntiCompaction(files, myRanges, null, newFiles);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Original file : " + file + " of size " + new File(file).length()));
        }
        this.sstableLock_.writeLock().lock();
        try {
            this.ssTables_.remove(file);
            for (String newfile : newFiles) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("New file : " + newfile + " of size " + new File(newfile).length()));
                }
                assert (newfile != null);
                this.ssTables_.put(newfile, SSTableReader.open(newfile));
            }
            SSTableReader.get(file).delete();
        }
        finally {
            this.sstableLock_.writeLock().unlock();
        }
    }

    boolean doFileAntiCompaction(List<String> files, List<Range> ranges, EndPoint target, List<String> fileList) throws IOException {
        boolean result = false;
        long startTime = System.currentTimeMillis();
        long totalBytesRead = 0L;
        long totalBytesWritten = 0L;
        long totalkeysRead = 0L;
        long totalkeysWritten = 0L;
        long expectedRangeFileSize = this.getExpectedCompactedFileSize(files);
        String rangeFileLocation = DatabaseDescriptor.getDataFileLocationForTable(this.table_, expectedRangeFileSize /= 2L);
        if (rangeFileLocation == null) {
            logger_.error((Object)("Total bytes to be written for range compaction  ..." + expectedRangeFileSize + "   is greater than the safe limit of the disk space available."));
            return result;
        }
        PriorityQueue<FileStruct> pq = this.initializePriorityQueue(files, ranges);
        if (pq.isEmpty()) {
            return result;
        }
        String mergedFileName = this.getTempSSTableFileName();
        SSTableWriter rangeWriter = null;
        String lastkey = null;
        ArrayList<FileStruct> lfs = new ArrayList<FileStruct>();
        DataOutputBuffer bufOut = new DataOutputBuffer();
        int expectedBloomFilterSize = SSTableReader.getApproximateKeyCount(files);
        int n = expectedBloomFilterSize = expectedBloomFilterSize > 0 ? expectedBloomFilterSize : SSTableReader.indexInterval();
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Expected bloom filter size : " + expectedBloomFilterSize));
        }
        ArrayList<ColumnFamily> columnFamilies = new ArrayList<ColumnFamily>();
        while (pq.size() > 0 || lfs.size() > 0) {
            FileStruct fs = null;
            if (pq.size() > 0) {
                fs = pq.poll();
            }
            if (fs != null && (lastkey == null || lastkey.equals(fs.getKey()))) {
                lastkey = fs.getKey();
                lfs.add(fs);
                continue;
            }
            Collections.sort(lfs, new FileStructComparator());
            bufOut.reset();
            if (lfs.size() > 1) {
                for (FileStruct filestruct : lfs) {
                    if (columnFamilies.size() > 1) {
                        ColumnFamilyStore.merge(columnFamilies);
                    }
                    columnFamilies.add(filestruct.getColumnFamily());
                }
                ColumnFamily columnFamily = ColumnFamilyStore.resolveAndRemoveDeleted(columnFamilies);
                columnFamilies.clear();
                if (columnFamily != null) {
                    ColumnFamily.serializer().serializeWithIndexes(columnFamily, bufOut);
                }
            } else {
                FileStruct filestruct = (FileStruct)lfs.get(0);
                ColumnFamily.serializer().serializeWithIndexes(filestruct.getColumnFamily(), bufOut);
            }
            if (Range.isTokenInRanges(StorageService.getPartitioner().getToken(lastkey), ranges)) {
                if (rangeWriter == null) {
                    if (target != null) {
                        rangeFileLocation = rangeFileLocation + File.separator + "bootstrap";
                    }
                    FileUtils.createDirectory(rangeFileLocation);
                    String fname = new File(rangeFileLocation, mergedFileName).getAbsolutePath();
                    rangeWriter = new SSTableWriter(fname, expectedBloomFilterSize, StorageService.getPartitioner());
                }
                rangeWriter.append(lastkey, bufOut);
            }
            ++totalkeysWritten;
            for (FileStruct filestruct : lfs) {
                filestruct.advance(true);
                if (filestruct.isExhausted()) continue;
                while (!Range.isTokenInRanges(StorageService.getPartitioner().getToken(filestruct.getKey()), ranges)) {
                    filestruct.advance(true);
                    if (!filestruct.isExhausted()) continue;
                }
                if (!filestruct.isExhausted()) {
                    pq.add(filestruct);
                }
                ++totalkeysRead;
            }
            lfs.clear();
            lastkey = null;
            if (fs == null) continue;
            pq.add(fs);
        }
        if (rangeWriter != null) {
            rangeWriter.closeAndOpenReader();
            if (fileList != null) {
                fileList.add(rangeWriter.indexFilename());
                fileList.add(rangeWriter.filterFilename());
                fileList.add(rangeWriter.getFilename());
            }
            result = true;
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Total time taken for range split   ..." + (System.currentTimeMillis() - startTime)));
            logger_.debug((Object)("Total bytes Read for range split  ..." + totalBytesRead));
            logger_.debug((Object)("Total bytes written for range split  ..." + totalBytesWritten + "   Total keys read ..." + totalkeysRead));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doFileCompaction(List<String> files, int minBufferSize) throws IOException {
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            Table.open(this.table_).snapshot("compact-" + this.columnFamily_);
        }
        logger_.info((Object)("Compacting [" + StringUtils.join(files, (String)",") + "]"));
        String compactionFileLocation = DatabaseDescriptor.getDataFileLocationForTable(this.table_, this.getExpectedCompactedFileSize(files));
        if (compactionFileLocation == null) {
            String maxFile = this.getMaxSizeFile(files);
            ArrayList<String> smallerSSTables = new ArrayList<String>(files);
            smallerSSTables.remove(maxFile);
            return this.doFileCompaction(smallerSSTables, minBufferSize);
        }
        String newfile = null;
        long startTime = System.currentTimeMillis();
        long totalBytesRead = 0L;
        long totalBytesWritten = 0L;
        long totalkeysRead = 0L;
        long totalkeysWritten = 0L;
        PriorityQueue<FileStruct> pq = this.initializePriorityQueue(files, null);
        if (pq.isEmpty()) {
            logger_.warn((Object)"Nothing to compact (all files empty or corrupt)");
            return 0;
        }
        String mergedFileName = this.getTempSSTableFileName();
        SSTableWriter writer = null;
        SSTableReader ssTable = null;
        String lastkey = null;
        ArrayList<FileStruct> lfs = new ArrayList<FileStruct>();
        DataOutputBuffer bufOut = new DataOutputBuffer();
        int expectedBloomFilterSize = SSTableReader.getApproximateKeyCount(files);
        int n = expectedBloomFilterSize = expectedBloomFilterSize > 0 ? expectedBloomFilterSize : SSTableReader.indexInterval();
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Expected bloom filter size : " + expectedBloomFilterSize));
        }
        ArrayList<ColumnFamily> columnFamilies = new ArrayList<ColumnFamily>();
        while (pq.size() > 0 || lfs.size() > 0) {
            FileStruct fs = null;
            if (pq.size() > 0) {
                fs = pq.poll();
            }
            if (fs != null && (lastkey == null || lastkey.equals(fs.getKey()))) {
                lastkey = fs.getKey();
                lfs.add(fs);
                continue;
            }
            Collections.sort(lfs, new FileStructComparator());
            bufOut.reset();
            if (lfs.size() > 1) {
                for (FileStruct filestruct : lfs) {
                    if (columnFamilies.size() > 1) {
                        ColumnFamilyStore.merge(columnFamilies);
                    }
                    columnFamilies.add(filestruct.getColumnFamily());
                }
                ColumnFamily columnFamily = ColumnFamilyStore.resolveAndRemoveDeleted(columnFamilies);
                columnFamilies.clear();
                if (columnFamily != null) {
                    ColumnFamily.serializer().serializeWithIndexes(columnFamily, bufOut);
                }
            } else {
                FileStruct filestruct = (FileStruct)lfs.get(0);
                ColumnFamily.serializer().serializeWithIndexes(filestruct.getColumnFamily(), bufOut);
            }
            if (writer == null) {
                String fname = new File(compactionFileLocation, mergedFileName).getAbsolutePath();
                writer = new SSTableWriter(fname, expectedBloomFilterSize, StorageService.getPartitioner());
            }
            writer.append(lastkey, bufOut);
            ++totalkeysWritten;
            for (FileStruct filestruct : lfs) {
                filestruct.advance(true);
                if (filestruct.isExhausted()) continue;
                pq.add(filestruct);
                ++totalkeysRead;
            }
            lfs.clear();
            lastkey = null;
            if (fs == null) continue;
            pq.add(fs);
        }
        if (writer != null) {
            ssTable = writer.closeAndOpenReader();
            newfile = writer.getFilename();
        }
        this.sstableLock_.writeLock().lock();
        try {
            for (String file : files) {
                this.ssTables_.remove(file);
            }
            if (newfile != null) {
                this.ssTables_.put(newfile, ssTable);
                totalBytesWritten += new File(newfile).length();
            }
            for (String file : files) {
                SSTableReader.get(file).delete();
            }
        }
        finally {
            this.sstableLock_.writeLock().unlock();
        }
        String format = "Compacted to %s.  %d/%d bytes for %d/%d keys read/written.  Time: %dms.";
        long dTime = System.currentTimeMillis() - startTime;
        logger_.info((Object)String.format(format, newfile, totalBytesRead, totalBytesWritten, totalkeysRead, totalkeysWritten, dTime));
        return files.size();
    }

    public static List<Memtable> getUnflushedMemtables(String cfName) {
        return new ArrayList<Memtable>(ColumnFamilyStore.getMemtablesPendingFlushNotNull(cfName));
    }

    private static Set<Memtable> getMemtablesPendingFlushNotNull(String columnFamilyName) {
        Set memtables = (Set)memtablesPendingFlush.get((Object)columnFamilyName);
        if (memtables == null) {
            memtablesPendingFlush.putIfAbsent((Object)columnFamilyName, new ConcurrentSkipListSet());
            memtables = (Set)memtablesPendingFlush.get((Object)columnFamilyName);
        }
        return memtables;
    }

    private static void submitFlush(final Memtable memtable, final CommitLog.CommitLogContext cLogCtx) {
        logger_.info((Object)("Enqueuing flush of " + memtable));
        flusher_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    memtable.flush(cLogCtx);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ColumnFamilyStore.getMemtablesPendingFlushNotNull(memtable.getColumnFamily()).remove(memtable);
            }
        });
    }

    static void submitFlush(final BinaryMemtable binaryMemtable) {
        logger_.info((Object)("Enqueuing flush of " + binaryMemtable));
        flusher_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    binaryMemtable.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public boolean isSuper() {
        return this.isSuper_;
    }

    public void flushMemtableOnRecovery() throws IOException {
        this.getMemtableThreadSafe().flushOnRecovery();
    }

    @Override
    public int getMemtableColumnsCount() {
        return this.getMemtableThreadSafe().getCurrentObjectCount();
    }

    @Override
    public int getMemtableDataSize() {
        return this.getMemtableThreadSafe().getCurrentSize();
    }

    @Override
    public int getMemtableSwitchCount() {
        return this.memtableSwitchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Memtable getMemtableThreadSafe() {
        this.memtableLock_.readLock().lock();
        try {
            Memtable memtable = this.memtable_;
            return memtable;
        }
        finally {
            this.memtableLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> memtableKeyIterator() throws ExecutionException, InterruptedException {
        Set<String> keys;
        this.memtableLock_.readLock().lock();
        try {
            keys = this.memtable_.getKeys();
        }
        finally {
            this.memtableLock_.readLock().unlock();
        }
        return Memtable.getKeyIterator(keys);
    }

    public Collection<SSTableReader> getSSTables() {
        return Collections.unmodifiableCollection(this.ssTables_.values());
    }

    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.sstableLock_.readLock();
    }

    @Override
    public int getReadCount() {
        return this.readStats_.size();
    }

    @Override
    public double getReadLatency() {
        return this.readStats_.mean();
    }

    @Override
    public int getPendingTasks() {
        return this.memtableLock_.getQueueLength();
    }

    @Override
    public int getWriteCount() {
        return this.writeStats_.size();
    }

    @Override
    public double getWriteLatency() {
        return this.writeStats_.mean();
    }

    public ColumnFamily getColumnFamily(String key, QueryPath path, byte[] start, byte[] finish, boolean reversed, int limit) throws IOException {
        return this.getColumnFamily(new SliceQueryFilter(key, path, start, finish, reversed, limit));
    }

    public ColumnFamily getColumnFamily(QueryFilter filter) throws IOException {
        return this.getColumnFamily(filter, ColumnFamilyStore.getDefaultGCBefore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnFamily getColumnFamily(QueryFilter filter, int gcBefore) throws IOException {
        assert (this.columnFamily_.equals(filter.getColumnFamilyName()));
        long start = System.currentTimeMillis();
        if (filter.path.superColumnName != null) {
            NamesQueryFilter nameFilter = new NamesQueryFilter(filter.key, new QueryPath(this.columnFamily_), filter.path.superColumnName);
            ColumnFamily cf = this.getColumnFamily(nameFilter);
            if (cf == null || cf.getColumnCount() == 0) {
                return cf;
            }
            assert (cf.getSortedColumns().size() == 1);
            SuperColumn sc = (SuperColumn)cf.getSortedColumns().iterator().next();
            SuperColumn scFiltered = filter.filterSuperColumn(sc, gcBefore);
            ColumnFamily cfFiltered = cf.cloneMeShallow();
            cfFiltered.addColumn(scFiltered);
            this.readStats_.add(System.currentTimeMillis() - start);
            return cfFiltered;
        }
        this.sstableLock_.readLock().lock();
        ArrayList<ColumnIterator> iterators = new ArrayList<ColumnIterator>();
        try {
            ColumnFamily returnCF;
            ColumnIterator iter;
            this.memtableLock_.readLock().lock();
            try {
                iter = filter.getMemColumnIterator(this.memtable_, this.getComparator());
                returnCF = iter.getColumnFamily();
            }
            finally {
                this.memtableLock_.readLock().unlock();
            }
            iterators.add(iter);
            List<Memtable> memtables = ColumnFamilyStore.getUnflushedMemtables(filter.getColumnFamilyName());
            for (Memtable memtable : memtables) {
                iter = filter.getMemColumnIterator(memtable, this.getComparator());
                returnCF.delete(iter.getColumnFamily());
                iterators.add(iter);
            }
            ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(this.ssTables_.values());
            for (SSTableReader sstable : sstables) {
                iter = filter.getSSTableColumnIterator(sstable);
                if (iter.hasNext()) {
                    returnCF.delete(iter.getColumnFamily());
                }
                iterators.add(iter);
            }
            Comparator<IColumn> comparator = filter.getColumnComparator(this.getComparator());
            Iterator collated = IteratorUtils.collatedIterator(comparator, iterators);
            if (!collated.hasNext()) {
                ColumnFamily columnFamily = null;
                return columnFamily;
            }
            filter.collectCollatedColumns(returnCF, collated, gcBefore);
            ColumnFamily columnFamily = ColumnFamilyStore.removeDeleted(returnCF, gcBefore);
            return columnFamily;
        }
        finally {
            for (ColumnIterator ci : iterators) {
                try {
                    ci.close();
                }
                catch (Throwable th) {
                    logger_.error((Object)("error closing " + ci), th);
                }
            }
            this.readStats_.add(System.currentTimeMillis() - start);
            this.sstableLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangeReply getKeyRange(String startWith, String stopAt, int maxResults) throws IOException, ExecutionException, InterruptedException {
        this.getReadLock().lock();
        try {
            RangeReply rangeReply = this.getKeyRangeUnsafe(startWith, stopAt, maxResults);
            return rangeReply;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangeReply getKeyRangeUnsafe(final String startWith, final String stopAt, int maxResults) throws IOException, ExecutionException, InterruptedException {
        final Comparator<String> comparator = StorageService.getPartitioner().getDecoratedKeyComparator();
        ArrayList<Iterator> iterators = new ArrayList<Iterator>();
        Predicate p = new Predicate(){

            public boolean evaluate(Object key) {
                String st = (String)key;
                return comparator.compare(startWith, st) <= 0 && (stopAt.isEmpty() || comparator.compare(st, stopAt) <= 0);
            }
        };
        iterators.add(IteratorUtils.filteredIterator(this.memtableKeyIterator(), (Predicate)p));
        for (Memtable memtable : ColumnFamilyStore.getUnflushedMemtables(this.columnFamily_)) {
            iterators.add(IteratorUtils.filteredIterator(Memtable.getKeyIterator(memtable.getKeys()), (Predicate)p));
        }
        for (SSTableReader sstable : this.getSSTables()) {
            FileStruct fs = sstable.getFileStruct();
            fs.seekTo(startWith);
            iterators.add(fs);
        }
        Iterator collated = IteratorUtils.collatedIterator(comparator, iterators);
        ReducingIterator<String> reduced = new ReducingIterator<String>(collated){
            String current;

            @Override
            public void reduce(String current) {
                this.current = current;
            }

            @Override
            protected String getReduced() {
                return this.current;
            }
        };
        try {
            ArrayList<String> keys = new ArrayList<String>();
            boolean rangeCompletedLocally = false;
            for (String current : reduced) {
                if (!stopAt.isEmpty() && comparator.compare(stopAt, current) < 0) {
                    rangeCompletedLocally = true;
                    break;
                }
                SliceQueryFilter filter = new SliceQueryFilter(current, new QueryPath(this.columnFamily_), ArrayUtils.EMPTY_BYTE_ARRAY, ArrayUtils.EMPTY_BYTE_ARRAY, false, 1);
                if (this.getColumnFamily(filter, Integer.MAX_VALUE) != null) {
                    keys.add(current);
                }
                if (keys.size() < maxResults) continue;
                rangeCompletedLocally = true;
                break;
            }
            RangeReply rangeReply = new RangeReply(keys, rangeCompletedLocally);
            return rangeReply;
        }
        finally {
            for (Iterator iter : iterators) {
                if (!(iter instanceof FileStruct)) continue;
                ((FileStruct)iter).close();
            }
        }
    }

    public AbstractType getComparator() {
        return DatabaseDescriptor.getComparator(this.table_, this.columnFamily_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot(String snapshotName) throws IOException {
        try {
            this.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.sstableLock_.readLock().lock();
        try {
            for (SSTableReader ssTable : new ArrayList<SSTableReader>(this.ssTables_.values())) {
                File sourceFile = new File(ssTable.getFilename());
                File dataDirectory = sourceFile.getParentFile().getParentFile();
                String snapshotDirectoryPath = Table.getSnapshotPath(dataDirectory.getAbsolutePath(), this.table_, snapshotName);
                FileUtils.createDirectory(snapshotDirectoryPath);
                File targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
                FileUtils.createHardLink(sourceFile, targetLink);
                sourceFile = new File(ssTable.indexFilename());
                targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
                FileUtils.createHardLink(sourceFile, targetLink);
                sourceFile = new File(ssTable.filterFilename());
                targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
                FileUtils.createHardLink(sourceFile, targetLink);
                if (!logger_.isDebugEnabled()) continue;
                logger_.debug((Object)("Snapshot for " + this.table_ + " table data file " + sourceFile.getAbsolutePath() + " created as " + targetLink.getAbsolutePath()));
            }
        }
        finally {
            this.sstableLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUnsafe() {
        this.sstableLock_.writeLock().lock();
        try {
            this.memtable_.clearUnsafe();
        }
        finally {
            this.sstableLock_.writeLock().unlock();
        }
    }
}

