/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collection;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.commons.lang.ArrayUtils;

public final class Column
implements IColumn {
    private static ColumnSerializer serializer_ = new ColumnSerializer();
    private final byte[] name;
    private final byte[] value;
    private final long timestamp;
    private final boolean isMarkedForDelete;

    static ColumnSerializer serializer() {
        return serializer_;
    }

    Column(byte[] name) {
        this(name, ArrayUtils.EMPTY_BYTE_ARRAY);
    }

    Column(byte[] name, byte[] value) {
        this(name, value, 0L);
    }

    public Column(byte[] name, byte[] value, long timestamp) {
        this(name, value, timestamp, false);
    }

    public Column(byte[] name, byte[] value, long timestamp, boolean isDeleted) {
        assert (name != null);
        assert (value != null);
        assert (name.length <= 65535);
        this.name = name;
        this.value = value;
        this.timestamp = timestamp;
        this.isMarkedForDelete = isDeleted;
    }

    @Override
    public byte[] name() {
        return this.name;
    }

    @Override
    public Column getSubColumn(byte[] columnName) {
        throw new UnsupportedOperationException("This operation is unsupported on simple columns.");
    }

    @Override
    public byte[] value() {
        return this.value;
    }

    @Override
    public byte[] value(byte[] key) {
        throw new UnsupportedOperationException("This operation is unsupported on simple columns.");
    }

    @Override
    public Collection<IColumn> getSubColumns() {
        throw new UnsupportedOperationException("This operation is unsupported on simple columns.");
    }

    @Override
    public int getObjectCount() {
        return 1;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long timestamp(byte[] key) {
        throw new UnsupportedOperationException("This operation is unsupported on simple columns.");
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.isMarkedForDelete;
    }

    @Override
    public long getMarkedForDeleteAt() {
        if (!this.isMarkedForDelete()) {
            throw new IllegalStateException("column is not marked for delete");
        }
        return this.timestamp;
    }

    @Override
    public long mostRecentChangeAt() {
        return this.timestamp;
    }

    @Override
    public int size() {
        return 2 + this.name.length + 1 + 8 + 4 + this.value.length;
    }

    @Override
    public int serializedSize() {
        return this.size();
    }

    @Override
    public void addColumn(IColumn column) {
        throw new UnsupportedOperationException("This operation is not supported for simple columns.");
    }

    @Override
    public IColumn diff(IColumn column) {
        if (this.timestamp() < column.timestamp()) {
            return column;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name);
        digest.update(this.value);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeBoolean(this.isMarkedForDelete);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        assert (this.isMarkedForDelete);
        return ByteBuffer.wrap(this.value).getInt();
    }

    public long comparePriority(Column o) {
        if (this.isMarkedForDelete) {
            return this.timestamp < o.timestamp ? -1L : 1L;
        }
        return this.timestamp - o.timestamp;
    }

    @Override
    public String getString(AbstractType comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(comparator.getString(this.name));
        sb.append(":");
        sb.append(this.isMarkedForDelete());
        sb.append(":");
        sb.append(this.value.length);
        sb.append("@");
        sb.append(this.timestamp());
        return sb.toString();
    }
}

