/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowMutationMessage;
import org.apache.cassandra.db.RowMutationVerbHandler;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class BinaryVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(BinaryVerbHandler.class);
    private static ThreadLocal<RowMutationVerbHandler.RowMutationContext> tls_ = new InheritableThreadLocal<RowMutationVerbHandler.RowMutationContext>();

    @Override
    public void doVerb(Message message) {
        block3: {
            byte[] bytes = message.getMessageBody();
            RowMutationVerbHandler.RowMutationContext rowMutationCtx = tls_.get();
            if (rowMutationCtx == null) {
                rowMutationCtx = new RowMutationVerbHandler.RowMutationContext();
                tls_.set(rowMutationCtx);
            }
            rowMutationCtx.buffer_.reset(bytes, bytes.length);
            try {
                RowMutationMessage rmMsg = RowMutationMessage.serializer().deserialize(rowMutationCtx.buffer_);
                RowMutation rm = rmMsg.getRowMutation();
                rowMutationCtx.row_.setKey(rm.key());
                rm.applyBinary(rowMutationCtx.row_);
            }
            catch (Exception e) {
                if (!logger_.isDebugEnabled()) break block3;
                logger_.debug((Object)LogUtil.throwableToString(e));
            }
        }
    }
}

