/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.service.StorageService;
import org.apache.log4j.Logger;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class BinaryMemtable {
    private static Logger logger_ = Logger.getLogger(Memtable.class);
    private int threshold_ = DatabaseDescriptor.getBMTThreshold() * 1024 * 1024;
    private AtomicInteger currentSize_ = new AtomicInteger(0);
    private String table_;
    private String cfName_;
    private boolean isFrozen_ = false;
    private Map<String, byte[]> columnFamilies_ = new NonBlockingHashMap();
    Lock lock_ = new ReentrantLock();
    Condition condition_ = this.lock_.newCondition();

    BinaryMemtable(String table, String cfName) throws IOException {
        this.table_ = table;
        this.cfName_ = cfName;
    }

    public int getMemtableThreshold() {
        return this.currentSize_.get();
    }

    void resolveSize(int oldSize, int newSize) {
        this.currentSize_.addAndGet(newSize - oldSize);
    }

    boolean isThresholdViolated() {
        if (this.currentSize_.get() >= this.threshold_ || this.columnFamilies_.size() > 50000) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("CURRENT SIZE:" + this.currentSize_.get()));
            }
            return true;
        }
        return false;
    }

    String getColumnFamily() {
        return this.cfName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String key, byte[] buffer) throws IOException {
        if (this.isThresholdViolated()) {
            this.lock_.lock();
            try {
                ColumnFamilyStore cfStore = Table.open(this.table_).getColumnFamilyStore(this.cfName_);
                if (!this.isFrozen_) {
                    this.isFrozen_ = true;
                    ColumnFamilyStore.submitFlush(this);
                    cfStore.switchBinaryMemtable(key, buffer);
                }
                cfStore.applyBinary(key, buffer);
            }
            finally {
                this.lock_.unlock();
            }
        } else {
            this.resolve(key, buffer);
        }
    }

    private void resolve(String key, byte[] buffer) {
        this.columnFamilies_.put(key, buffer);
        this.currentSize_.addAndGet(buffer.length + key.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() throws IOException {
        SSTableWriter writer;
        if (this.columnFamilies_.size() == 0) {
            return;
        }
        ColumnFamilyStore cfStore = Table.open(this.table_).getColumnFamilyStore(this.cfName_);
        ArrayList<String> keys = new ArrayList<String>(this.columnFamilies_.keySet());
        this.lock_.lock();
        try {
            String path = cfStore.getTempSSTablePath();
            writer = new SSTableWriter(path, keys.size(), StorageService.getPartitioner());
        }
        finally {
            this.lock_.unlock();
        }
        IPartitioner partitioner = StorageService.getPartitioner();
        Comparator<String> dc = partitioner.getDecoratedKeyComparator();
        Collections.sort(keys, dc);
        for (String key : keys) {
            byte[] bytes = this.columnFamilies_.get(key);
            if (bytes.length <= 0) continue;
            writer.append(key, bytes);
        }
        cfStore.storeLocation(writer.closeAndOpenReader());
        this.columnFamilies_.clear();
    }
}

