/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CommitLog;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.utils.FileUtils;
import org.apache.cassandra.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseDescriptor {
    private static Logger logger_ = Logger.getLogger(DatabaseDescriptor.class);
    public static final String random_ = "RANDOM";
    public static final String ophf_ = "OPHF";
    private static int storagePort_ = 7000;
    private static int controlPort_ = 7001;
    private static int thriftPort_ = 9160;
    private static boolean thriftFramed_ = false;
    private static String listenAddress_;
    private static String thriftAddress_;
    private static String clusterName_;
    private static int replicationFactor_;
    private static long rpcTimeoutInMillis_;
    private static Set<String> seeds_;
    private static String[] dataFileDirectories_;
    private static int currentIndex_;
    private static String logFileDirectory_;
    private static String bootstrapFileDirectory_;
    private static int consistencyThreads_;
    private static int concurrentReaders_;
    private static int concurrentWriters_;
    private static double flushDataBufferSizeInMB_;
    private static double flushIndexBufferSizeInMB_;
    private static int slicedReadBufferSizeInKB_;
    private static List<String> tables_;
    private static Set<String> applicationColumnFamilies_;
    private static int flushMinThreads_;
    private static int flushMaxThreads_;
    private static int bmtThreshold_;
    private static String d_rowKey_;
    private static String d_superColumnMap_;
    private static String d_superColumnKey_;
    private static String d_columnMap_;
    private static String d_columnKey_;
    private static String d_columnValue_;
    private static String d_columnTimestamp_;
    private static Map<String, Map<String, CFMetaData>> tableToCFMetaDataMap_;
    private static IPartitioner partitioner_;
    private static IEndPointSnitch endPointSnitch_;
    private static Class replicaPlacementStrategyClass_;
    private static int columnIndexSizeInKB_;
    private static int memtableLifetime_;
    private static int memtableSize_;
    private static double memtableObjectCount_;
    private static boolean doConsistencyCheck_;
    private static String jobJarFileLocation_;
    private static String jobTrackerHost_;
    private static int gcGraceInSeconds_;
    private static String configFileName_;
    private static String initialToken_;
    private static CommitLogSync commitLogSync_;
    private static double commitLogSyncBatchMS_;
    private static int commitLogSyncPeriodMS_;
    private static boolean snapshotBeforeCompaction_;

    public static boolean isThriftFramed() {
        return thriftFramed_;
    }

    private static AbstractType getComparator(Node columnFamily, String attr) throws ConfigurationException, TransformerException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class typeClass;
        String compareWith = XMLUtils.getAttributeValue(columnFamily, attr);
        if (compareWith == null) {
            typeClass = BytesType.class;
        } else {
            String className = compareWith.contains(".") ? compareWith : "org.apache.cassandra.db.marshal." + compareWith;
            try {
                typeClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Unable to load class " + className + " for " + attr + " attribute");
            }
        }
        return (AbstractType)typeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void createTableDirectories() throws IOException {
        for (String dataFile : dataFileDirectories_) {
            FileUtils.createDirectory(dataFile + File.separator + "system");
            for (String table : tables_) {
                FileUtils.createDirectory(dataFile + File.separator + table);
            }
        }
    }

    public static void storeMetadata() throws IOException {
        int cfId = 0;
        Set<String> tables = tableToCFMetaDataMap_.keySet();
        for (String table : tables) {
            Table.TableMetadata tmetadata = Table.TableMetadata.instance(table);
            if (!tmetadata.isEmpty()) continue;
            tmetadata = Table.TableMetadata.instance(table);
            Map<String, CFMetaData> columnFamilies = tableToCFMetaDataMap_.get(table);
            for (String columnFamily : columnFamilies.keySet()) {
                tmetadata.add(columnFamily, cfId++, DatabaseDescriptor.getColumnType(table, columnFamily));
            }
        }
    }

    public static int getGcGraceInSeconds() {
        return gcGraceInSeconds_;
    }

    public static IPartitioner getPartitioner() {
        return partitioner_;
    }

    public static IEndPointSnitch getEndPointSnitch() {
        return endPointSnitch_;
    }

    public static Class getReplicaPlacementStrategyClass() {
        return replicaPlacementStrategyClass_;
    }

    public static String getJobTrackerAddress() {
        return jobTrackerHost_;
    }

    public static int getColumnIndexSize() {
        return columnIndexSizeInKB_ * 1024;
    }

    public static int getMemtableLifetime() {
        return memtableLifetime_;
    }

    public static String getInitialToken() {
        return initialToken_;
    }

    public static int getMemtableSize() {
        return memtableSize_;
    }

    public static double getMemtableObjectCount() {
        return memtableObjectCount_;
    }

    public static boolean getConsistencyCheck() {
        return doConsistencyCheck_;
    }

    public static String getClusterName() {
        return clusterName_;
    }

    public static String getConfigFileName() {
        return configFileName_;
    }

    public static boolean isApplicationColumnFamily(String columnFamily) {
        return applicationColumnFamilies_.contains(columnFamily);
    }

    public static String getJobJarLocation() {
        return jobJarFileLocation_;
    }

    public static Map<String, CFMetaData> getTableMetaData(String tableName) {
        assert (tableName != null);
        return tableToCFMetaDataMap_.get(tableName);
    }

    public static CFMetaData getCFMetaData(String tableName, String cfName) {
        assert (tableName != null);
        Map<String, CFMetaData> cfInfo = tableToCFMetaDataMap_.get(tableName);
        if (cfInfo == null) {
            return null;
        }
        return cfInfo.get(cfName);
    }

    public static String getColumnType(String tableName, String cfName) {
        assert (tableName != null);
        CFMetaData cfMetaData = DatabaseDescriptor.getCFMetaData(tableName, cfName);
        if (cfMetaData == null) {
            return null;
        }
        return cfMetaData.columnType;
    }

    public static int getFlushPeriod(String tableName, String columnFamilyName) {
        assert (tableName != null);
        CFMetaData cfMetaData = DatabaseDescriptor.getCFMetaData(tableName, columnFamilyName);
        if (cfMetaData == null) {
            return 0;
        }
        return cfMetaData.flushPeriodInMinutes;
    }

    public static List<String> getTables() {
        return tables_;
    }

    public static String getTable(String tableName) {
        assert (tableName != null);
        int index = DatabaseDescriptor.getTables().indexOf(tableName);
        return index >= 0 ? DatabaseDescriptor.getTables().get(index) : null;
    }

    public static void setTables(String table) {
        tables_.add(table);
    }

    public static int getStoragePort() {
        return storagePort_;
    }

    public static int getControlPort() {
        return controlPort_;
    }

    public static int getThriftPort() {
        return thriftPort_;
    }

    public static int getReplicationFactor() {
        return replicationFactor_;
    }

    public static int getQuorum() {
        return replicationFactor_ / 2 + 1;
    }

    public static long getRpcTimeout() {
        return rpcTimeoutInMillis_;
    }

    public static int getConsistencyThreads() {
        return consistencyThreads_;
    }

    public static int getConcurrentReaders() {
        return concurrentReaders_;
    }

    public static int getConcurrentWriters() {
        return concurrentWriters_;
    }

    public static String[] getAllDataFileLocations() {
        return dataFileDirectories_;
    }

    public static String[] getAllDataFileLocationsForTable(String table) {
        String[] tableLocations = new String[dataFileDirectories_.length];
        for (int i = 0; i < dataFileDirectories_.length; ++i) {
            tableLocations[i] = dataFileDirectories_[i] + File.separator + table;
        }
        return tableLocations;
    }

    public static String getDataFileLocationForTable(String table) {
        String dataFileDirectory = dataFileDirectories_[currentIndex_] + File.separator + table;
        currentIndex_ = (currentIndex_ + 1) % dataFileDirectories_.length;
        return dataFileDirectory;
    }

    public static String getBootstrapFileLocation() {
        return bootstrapFileDirectory_;
    }

    public static void setBootstrapFileLocation(String bfLocation) {
        bootstrapFileDirectory_ = bfLocation;
    }

    public static String getLogFileLocation() {
        return logFileDirectory_;
    }

    public static void setLogFileLocation(String logLocation) {
        logFileDirectory_ = logLocation;
    }

    public static Set<String> getSeeds() {
        return seeds_;
    }

    public static String getColumnFamilyType(String tableName, String cfName) {
        assert (tableName != null);
        String cfType = DatabaseDescriptor.getColumnType(tableName, cfName);
        if (cfType == null) {
            cfType = "Standard";
        }
        return cfType;
    }

    public static String getDataFileLocationForTable(String table, long expectedCompactedFileSize) {
        long maxFreeDisk = 0L;
        int maxDiskIndex = 0;
        String dataFileDirectory = null;
        String[] dataDirectoryForTable = DatabaseDescriptor.getAllDataFileLocationsForTable(table);
        for (int i = 0; i < dataDirectoryForTable.length; ++i) {
            File f = new File(dataDirectoryForTable[i]);
            if (maxFreeDisk >= f.getUsableSpace()) continue;
            maxFreeDisk = f.getUsableSpace();
            maxDiskIndex = i;
        }
        if (expectedCompactedFileSize < (maxFreeDisk = (long)(0.9 * (double)maxFreeDisk))) {
            dataFileDirectory = dataDirectoryForTable[maxDiskIndex];
            currentIndex_ = (maxDiskIndex + 1) % dataDirectoryForTable.length;
        } else {
            currentIndex_ = maxDiskIndex;
        }
        return dataFileDirectory;
    }

    public static AbstractType getComparator(String tableName, String cfName) {
        assert (tableName != null);
        return DatabaseDescriptor.getCFMetaData((String)tableName, (String)cfName).comparator;
    }

    public static AbstractType getSubComparator(String tableName, String cfName) {
        assert (tableName != null);
        return DatabaseDescriptor.getCFMetaData((String)tableName, (String)cfName).subcolumnComparator;
    }

    public static Map<String, Map<String, CFMetaData>> getTableToColumnFamilyMap() {
        return tableToCFMetaDataMap_;
    }

    public static String getListenAddress() {
        return listenAddress_;
    }

    public static String getThriftAddress() {
        return thriftAddress_;
    }

    public static double getCommitLogSyncBatchWindow() {
        return commitLogSyncBatchMS_;
    }

    public static int getCommitLogSyncPeriod() {
        return commitLogSyncPeriodMS_;
    }

    public static CommitLogSync getCommitLogSync() {
        return commitLogSync_;
    }

    public static double getFlushDataBufferSizeInMB() {
        return flushDataBufferSizeInMB_;
    }

    public static double getFlushIndexBufferSizeInMB() {
        return flushIndexBufferSizeInMB_;
    }

    public static int getIndexedReadBufferSizeInKB() {
        return columnIndexSizeInKB_;
    }

    public static int getSlicedReadBufferSizeInKB() {
        return slicedReadBufferSizeInKB_;
    }

    public static int getFlushMinThreads() {
        return flushMinThreads_;
    }

    public static int getFlushMaxThreads() {
        return flushMaxThreads_;
    }

    public static int getBMTThreshold() {
        return bmtThreshold_;
    }

    public static boolean isSnapshotBeforeCompaction() {
        return snapshotBeforeCompaction_;
    }

    static {
        clusterName_ = "Test";
        replicationFactor_ = 3;
        rpcTimeoutInMillis_ = 2000L;
        seeds_ = new HashSet<String>();
        currentIndex_ = 0;
        consistencyThreads_ = 4;
        concurrentReaders_ = 8;
        concurrentWriters_ = 32;
        flushDataBufferSizeInMB_ = 32.0;
        flushIndexBufferSizeInMB_ = 8.0;
        slicedReadBufferSizeInKB_ = 64;
        tables_ = new ArrayList<String>();
        applicationColumnFamilies_ = new HashSet<String>();
        flushMinThreads_ = 1;
        flushMaxThreads_ = 1;
        bmtThreshold_ = 256;
        d_rowKey_ = "ROW_KEY";
        d_superColumnMap_ = "SUPER_COLUMN_MAP";
        d_superColumnKey_ = "SUPER_COLUMN_KEY";
        d_columnMap_ = "COLUMN_MAP";
        d_columnKey_ = "COLUMN_KEY";
        d_columnValue_ = "COLUMN_VALUE";
        d_columnTimestamp_ = "COLUMN_TIMESTAMP";
        memtableLifetime_ = 6;
        memtableSize_ = 128;
        memtableObjectCount_ = 1.0;
        doConsistencyCheck_ = true;
        gcGraceInSeconds_ = 864000;
        initialToken_ = null;
        try {
            String columnIndexSizeInKB;
            String memtableObjectCount;
            String memtableSize;
            String lifetime;
            String sbc;
            String framedRaw;
            String thriftAddress;
            String listenAddress;
            String port;
            String bmtThreshold;
            String rawflushMaxThreads;
            String rawflushMinThreads;
            String rawSlicedBuffer;
            String rawFlushIndex;
            String rawFlushData;
            String rawWriters;
            String rawReaders;
            String rpcTimeoutInMillis;
            configFileName_ = System.getProperty("storage-config") + File.separator + "storage-conf.xml";
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Loading settings from " + configFileName_));
            }
            XMLUtils xmlUtils = new XMLUtils(configFileName_);
            clusterName_ = xmlUtils.getNodeValue("/Storage/ClusterName");
            String syncRaw = xmlUtils.getNodeValue("/Storage/CommitLogSync");
            try {
                commitLogSync_ = CommitLogSync.valueOf(syncRaw);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("CommitLogSync must be either 'periodic' or 'batch'");
            }
            if (commitLogSync_ == null) {
                throw new ConfigurationException("Missing required directive CommitLogSync");
            }
            if (commitLogSync_ == CommitLogSync.batch) {
                try {
                    commitLogSyncBatchMS_ = Double.valueOf(xmlUtils.getNodeValue("/Storage/CommitLogSyncBatchWindowInMS"));
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unrecognized value for CommitLogSyncBatchWindowInMS.  Double expected.");
                }
                if (xmlUtils.getNodeValue("/Storage/CommitLogSyncPeriodInMS") != null) {
                    throw new ConfigurationException("Batch sync specified, but CommitLogSyncPeriodInMS found.  Only specify CommitLogSyncBatchWindowInMS when using batch sync.");
                }
                logger_.debug((Object)("Syncing log with a batch window of " + commitLogSyncBatchMS_));
            } else {
                assert (commitLogSync_ == CommitLogSync.periodic);
                try {
                    commitLogSyncPeriodMS_ = Integer.valueOf(xmlUtils.getNodeValue("/Storage/CommitLogSyncPeriodInMS"));
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unrecognized value for CommitLogSyncPeriodInMS.  Integer expected.");
                }
                if (xmlUtils.getNodeValue("/Storage/CommitLogSyncBatchWindowInMS") != null) {
                    throw new ConfigurationException("Periodic sync specified, but CommitLogSyncBatchWindowInMS found.  Only specify CommitLogSyncPeriodInMS when using periodic sync.");
                }
                logger_.debug((Object)("Syncing log with a period of " + commitLogSyncPeriodMS_));
            }
            String partitionerClassName = xmlUtils.getNodeValue("/Storage/Partitioner");
            if (partitionerClassName == null) {
                throw new ConfigurationException("Missing partitioner directive /Storage/Partitioner");
            }
            try {
                Class<?> cls = Class.forName(partitionerClassName);
                partitioner_ = (IPartitioner)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Invalid partitioner class " + partitionerClassName);
            }
            String endPointSnitchClassName = xmlUtils.getNodeValue("/Storage/EndPointSnitch");
            if (endPointSnitchClassName == null) {
                throw new ConfigurationException("Missing endpointsnitch directive /Storage/EndPointSnitch");
            }
            try {
                Class<?> cls = Class.forName(endPointSnitchClassName);
                endPointSnitch_ = (IEndPointSnitch)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Invalid endpointsnitch class " + endPointSnitchClassName);
            }
            jobTrackerHost_ = xmlUtils.getNodeValue("/Storage/JobTrackerHost");
            jobJarFileLocation_ = xmlUtils.getNodeValue("/Storage/JobJarFileLocation");
            String gcGrace = xmlUtils.getNodeValue("/Storage/GCGraceSeconds");
            if (gcGrace != null) {
                gcGraceInSeconds_ = Integer.parseInt(gcGrace);
            }
            initialToken_ = xmlUtils.getNodeValue("/Storage/InitialToken");
            String replicationFactor = xmlUtils.getNodeValue("/Storage/ReplicationFactor");
            if (replicationFactor != null) {
                replicationFactor_ = Integer.parseInt(replicationFactor);
            }
            if ((rpcTimeoutInMillis = xmlUtils.getNodeValue("/Storage/RpcTimeoutInMillis")) != null) {
                rpcTimeoutInMillis_ = Integer.parseInt(rpcTimeoutInMillis);
            }
            if ((rawReaders = xmlUtils.getNodeValue("/Storage/ConcurrentReads")) != null) {
                concurrentReaders_ = Integer.parseInt(rawReaders);
            }
            if ((rawWriters = xmlUtils.getNodeValue("/Storage/ConcurrentWrites")) != null) {
                concurrentWriters_ = Integer.parseInt(rawWriters);
            }
            if ((rawFlushData = xmlUtils.getNodeValue("/Storage/FlushDataBufferSizeInMB")) != null) {
                flushDataBufferSizeInMB_ = Double.parseDouble(rawFlushData);
            }
            if ((rawFlushIndex = xmlUtils.getNodeValue("/Storage/FlushIndexBufferSizeInMB")) != null) {
                flushIndexBufferSizeInMB_ = Double.parseDouble(rawFlushIndex);
            }
            if ((rawSlicedBuffer = xmlUtils.getNodeValue("/Storage/SlicedBufferSizeInKB")) != null) {
                slicedReadBufferSizeInKB_ = Integer.parseInt(rawSlicedBuffer);
            }
            if ((rawflushMinThreads = xmlUtils.getNodeValue("/Storage/FlushMinThreads")) != null) {
                flushMinThreads_ = Integer.parseInt(rawflushMinThreads);
            }
            if ((rawflushMaxThreads = xmlUtils.getNodeValue("/Storage/FlushMaxThreads")) != null) {
                flushMaxThreads_ = Integer.parseInt(rawflushMaxThreads);
            }
            if ((bmtThreshold = xmlUtils.getNodeValue("/Storage/BinaryMemtableSizeInMB")) != null) {
                bmtThreshold_ = Integer.parseInt(bmtThreshold);
            }
            if ((port = xmlUtils.getNodeValue("/Storage/StoragePort")) != null) {
                storagePort_ = Integer.parseInt(port);
            }
            if ((listenAddress = xmlUtils.getNodeValue("/Storage/ListenAddress")) != null) {
                listenAddress_ = listenAddress;
            }
            if ((thriftAddress = xmlUtils.getNodeValue("/Storage/ThriftAddress")) != null) {
                thriftAddress_ = thriftAddress;
            }
            if ((port = xmlUtils.getNodeValue("/Storage/ControlPort")) != null) {
                controlPort_ = Integer.parseInt(port);
            }
            if ((port = xmlUtils.getNodeValue("/Storage/ThriftPort")) != null) {
                thriftPort_ = Integer.parseInt(port);
            }
            if ((framedRaw = xmlUtils.getNodeValue("/Storage/ThriftFramedTransport")) != null) {
                if (framedRaw.equalsIgnoreCase("true") || framedRaw.equalsIgnoreCase("false")) {
                    thriftFramed_ = Boolean.valueOf(framedRaw);
                } else {
                    throw new ConfigurationException("Unrecognized value for ThriftFramedTransport.  Use 'true' or 'false'.");
                }
            }
            if ((sbc = xmlUtils.getNodeValue("/Storage/SnapshotBeforeCompaction")) != null) {
                if (sbc.equalsIgnoreCase("true") || sbc.equalsIgnoreCase("false")) {
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("setting snapshotBeforeCompaction to " + sbc));
                    }
                    snapshotBeforeCompaction_ = Boolean.valueOf(sbc);
                } else {
                    throw new ConfigurationException("Unrecognized value for SnapshotBeforeCompaction.  Use 'true' or 'false'.");
                }
            }
            if ((lifetime = xmlUtils.getNodeValue("/Storage/MemtableLifetimeInDays")) != null) {
                memtableLifetime_ = Integer.parseInt(lifetime);
            }
            if ((memtableSize = xmlUtils.getNodeValue("/Storage/MemtableSizeInMB")) != null) {
                memtableSize_ = Integer.parseInt(memtableSize);
            }
            if ((memtableObjectCount = xmlUtils.getNodeValue("/Storage/MemtableObjectCountInMillions")) != null) {
                memtableObjectCount_ = Double.parseDouble(memtableObjectCount);
            }
            if (memtableObjectCount_ <= 0.0) {
                throw new ConfigurationException("Memtable object count must be a positive double");
            }
            String doConsistencyCheck = xmlUtils.getNodeValue("/Storage/DoConsistencyChecksBoolean");
            if (doConsistencyCheck != null) {
                doConsistencyCheck_ = Boolean.parseBoolean(doConsistencyCheck);
            }
            columnIndexSizeInKB_ = (columnIndexSizeInKB = xmlUtils.getNodeValue("/Storage/ColumnIndexSizeInKB")) == null ? 64 : Integer.parseInt(columnIndexSizeInKB);
            dataFileDirectories_ = xmlUtils.getNodeValues("/Storage/DataFileDirectories/DataFileDirectory");
            if (dataFileDirectories_.length == 0) {
                throw new ConfigurationException("At least one DataFileDirectory must be specified");
            }
            for (String dataFileDirectory : dataFileDirectories_) {
                FileUtils.createDirectory(dataFileDirectory);
            }
            bootstrapFileDirectory_ = xmlUtils.getNodeValue("/Storage/BootstrapFileDirectory");
            if (bootstrapFileDirectory_ == null) {
                throw new ConfigurationException("BootstrapFileDirectory must be specified");
            }
            FileUtils.createDirectory(bootstrapFileDirectory_);
            logFileDirectory_ = xmlUtils.getNodeValue("/Storage/CommitLogDirectory");
            if (logFileDirectory_ == null) {
                throw new ConfigurationException("CommitLogDirectory must be specified");
            }
            FileUtils.createDirectory(logFileDirectory_);
            String value = xmlUtils.getNodeValue("/Storage/CommitLogRotationThresholdInMB");
            if (value != null) {
                CommitLog.setSegmentSize(Integer.parseInt(value) * 1024 * 1024);
            }
            tableToCFMetaDataMap_ = new HashMap<String, Map<String, CFMetaData>>();
            String replicaPlacementStrategyClassName = xmlUtils.getNodeValue("/Storage/ReplicaPlacementStrategy");
            if (replicaPlacementStrategyClassName == null) {
                throw new ConfigurationException("Missing replicaplacementstrategy directive /Storage/ReplicaPlacementStrategy");
            }
            try {
                replicaPlacementStrategyClass_ = Class.forName(replicaPlacementStrategyClassName);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Invalid replicaplacementstrategy class " + replicaPlacementStrategyClassName);
            }
            NodeList tables = xmlUtils.getRequestedNodeList("/Storage/Keyspaces/Keyspace");
            int size = tables.getLength();
            for (int i = 0; i < size; ++i) {
                Node table = tables.item(i);
                String tName = XMLUtils.getAttributeValue(table, "Name");
                if (tName == null) {
                    throw new ConfigurationException("Table name attribute is required");
                }
                if (tName.equalsIgnoreCase("system")) {
                    throw new ConfigurationException("'system' is a reserved table name for Cassandra internals");
                }
                tables_.add(tName);
                tableToCFMetaDataMap_.put(tName, new HashMap());
                String xqlTable = "/Storage/Keyspaces/Keyspace[@Name='" + tName + "']/";
                NodeList columnFamilies = xmlUtils.getRequestedNodeList(xqlTable + "ColumnFamily");
                String n_rowKey = xmlUtils.getNodeValue(xqlTable + "RowKey");
                if (n_rowKey == null) {
                    n_rowKey = d_rowKey_;
                }
                int size2 = columnFamilies.getLength();
                for (int j = 0; j < size2; ++j) {
                    String n_columnTimestamp;
                    String n_columnValue;
                    String n_columnKey;
                    String n_columnMap;
                    String n_superColumnKey;
                    String n_superColumnMap;
                    Node columnFamily = columnFamilies.item(j);
                    String cfName = XMLUtils.getAttributeValue(columnFamily, "Name");
                    if (cfName == null) {
                        throw new ConfigurationException("ColumnFamily name attribute is required");
                    }
                    String xqlCF = xqlTable + "ColumnFamily[@Name='" + cfName + "']/";
                    applicationColumnFamilies_.add(cfName);
                    String rawColumnType = XMLUtils.getAttributeValue(columnFamily, "ColumnType");
                    String columnType = ColumnFamily.getColumnType(rawColumnType);
                    if (columnType == null) {
                        throw new ConfigurationException("ColumnFamily " + cfName + " has invalid type " + rawColumnType);
                    }
                    if (XMLUtils.getAttributeValue(columnFamily, "ColumnSort") != null) {
                        throw new ConfigurationException("ColumnSort is no longer an accepted attribute.  Use CompareWith instead.");
                    }
                    AbstractType columnComparator = DatabaseDescriptor.getComparator(columnFamily, "CompareWith");
                    AbstractType subcolumnComparator = null;
                    if (columnType.equals("Super")) {
                        subcolumnComparator = DatabaseDescriptor.getComparator(columnFamily, "CompareSubcolumnsWith");
                    } else if (XMLUtils.getAttributeValue(columnFamily, "CompareSubcolumnsWith") != null) {
                        throw new ConfigurationException("CompareSubcolumnsWith is only a valid attribute on super columnfamilies (not regular columnfamily " + cfName + ")");
                    }
                    String flushPeriodInMinutes = XMLUtils.getAttributeValue(columnFamily, "FlushPeriodInMinutes");
                    int flushPeriod = 0;
                    if (flushPeriodInMinutes != null) {
                        flushPeriod = Integer.parseInt(flushPeriodInMinutes);
                    }
                    if ((n_superColumnMap = xmlUtils.getNodeValue(xqlCF + "SuperColumnMap")) == null) {
                        n_superColumnMap = d_superColumnMap_;
                    }
                    if ((n_superColumnKey = xmlUtils.getNodeValue(xqlCF + "SuperColumnKey")) == null) {
                        n_superColumnKey = d_superColumnKey_;
                    }
                    if ((n_columnMap = xmlUtils.getNodeValue(xqlCF + "ColumnMap")) == null) {
                        n_columnMap = d_columnMap_;
                    }
                    if ((n_columnKey = xmlUtils.getNodeValue(xqlCF + "ColumnKey")) == null) {
                        n_columnKey = d_columnKey_;
                    }
                    if ((n_columnValue = xmlUtils.getNodeValue(xqlCF + "ColumnValue")) == null) {
                        n_columnValue = d_columnValue_;
                    }
                    if ((n_columnTimestamp = xmlUtils.getNodeValue(xqlCF + "ColumnTimestamp")) == null) {
                        n_columnTimestamp = d_columnTimestamp_;
                    }
                    CFMetaData cfMetaData = new CFMetaData();
                    cfMetaData.tableName = tName;
                    cfMetaData.cfName = cfName;
                    cfMetaData.columnType = columnType;
                    cfMetaData.comparator = columnComparator;
                    cfMetaData.subcolumnComparator = subcolumnComparator;
                    cfMetaData.n_rowKey = n_rowKey;
                    cfMetaData.n_columnMap = n_columnMap;
                    cfMetaData.n_columnKey = n_columnKey;
                    cfMetaData.n_columnValue = n_columnValue;
                    cfMetaData.n_columnTimestamp = n_columnTimestamp;
                    if ("Super".equals(columnType)) {
                        cfMetaData.n_superColumnKey = n_superColumnKey;
                        cfMetaData.n_superColumnMap = n_superColumnMap;
                    }
                    cfMetaData.flushPeriodInMinutes = flushPeriod;
                    tableToCFMetaDataMap_.get(tName).put(cfName, cfMetaData);
                }
            }
            tables_.add("system");
            HashMap<String, CFMetaData> systemMetadata = new HashMap<String, CFMetaData>();
            CFMetaData data = new CFMetaData();
            data.columnType = "Standard";
            data.comparator = new UTF8Type();
            data.flushPeriodInMinutes = 1;
            systemMetadata.put("LocationInfo", data);
            data = new CFMetaData();
            data.columnType = "Super";
            data.comparator = new UTF8Type();
            data.subcolumnComparator = new BytesType();
            data.flushPeriodInMinutes = 10;
            systemMetadata.put("HintsColumnFamily", data);
            tableToCFMetaDataMap_.put("system", systemMetadata);
            DatabaseDescriptor.createTableDirectories();
            String[] seeds = xmlUtils.getNodeValues("/Storage/Seeds/Seed");
            for (int i = 0; i < seeds.length; ++i) {
                seeds_.add(seeds[i]);
            }
        }
        catch (ConfigurationException e) {
            logger_.error((Object)("Fatal error: " + e.getMessage()));
            System.err.println("Bad configuration; unable to start server");
            System.exit(1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ConfigurationException
    extends Exception {
        public ConfigurationException(String message) {
            super(message);
        }
    }

    public static enum CommitLogSync {
        periodic,
        batch;

    }
}

