/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.security;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.security.CamelSSLConfigurationProperties;
import org.apache.camel.support.jsse.CipherSuitesParameters;
import org.apache.camel.support.jsse.FilterParameters;
import org.apache.camel.support.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextClientParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.SSLContextServerParameters;
import org.apache.camel.support.jsse.SecureRandomParameters;
import org.apache.camel.support.jsse.SecureSocketProtocolsParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelSSLConfigurationProperties.class})
public class CamelSSLAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={SSLCondition.class})
    public SSLContextParameters sslContextParameters(CamelContext camelContext, CamelSSLConfigurationProperties properties) {
        SSLContextParameters sslContext = camelContext.getSSLContextParameters() != null ? this.copyParams(camelContext.getSSLContextParameters()) : new SSLContextParameters();
        SSLContextParameters config = new SSLContextBuilder(sslContext).certAlias(properties.getCertAlias()).cipherSuites(properties.getCipherSuites()).cipherSuitesFilter(properties.getCipherSuitesFilter()).clientParameters(properties.getClientParameters()).keyManagers(properties.getKeyManagers()).provider(properties.getProvider()).secureRandom(properties.getSecureRandom()).secureSocketProtocol(properties.getSecureSocketProtocol()).secureSocketProtocols(properties.getSecureSocketProtocols()).secureSocketProtocolsFilter(properties.getSecureSocketProtocolsFilter()).serverParameters(properties.getServerParameters()).sessionTimeout(properties.getSessionTimeout()).trustManager(properties.getTrustManagers()).build();
        return config;
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={SSLConfigCondition.class})
    public GlobalSSLContextParametersSupplier sslContextParametersSupplier(CamelSSLConfigurationProperties properties) {
        SSLContextParameters config = properties.getConfig() != null ? properties.getConfig() : new SSLContextParameters();
        return () -> config;
    }

    private SSLContextParameters copyParams(SSLContextParameters sslContextParameters) {
        SSLContextParameters copy = new SSLContextParameters();
        copy.setCertAlias(sslContextParameters.getCertAlias());
        copy.setCipherSuites(sslContextParameters.getCipherSuites());
        copy.setCipherSuitesFilter(sslContextParameters.getCipherSuitesFilter());
        copy.setClientParameters(sslContextParameters.getClientParameters());
        copy.setKeyManagers(sslContextParameters.getKeyManagers());
        copy.setProvider(sslContextParameters.getProvider());
        copy.setSecureRandom(sslContextParameters.getSecureRandom());
        copy.setSecureSocketProtocol(sslContextParameters.getSecureSocketProtocol());
        copy.setSecureSocketProtocols(sslContextParameters.getSecureSocketProtocols());
        copy.setSecureSocketProtocolsFilter(sslContextParameters.getSecureSocketProtocolsFilter());
        copy.setServerParameters(sslContextParameters.getServerParameters());
        copy.setSessionTimeout(sslContextParameters.getSessionTimeout());
        copy.setTrustManagers(sslContextParameters.getTrustManagers());
        return copy;
    }

    private class SSLContextBuilder {
        private SSLContextParameters sslContextParameters;

        public SSLContextBuilder(SSLContextParameters sslContextParameters) {
            this.sslContextParameters = sslContextParameters;
        }

        public SSLContextBuilder certAlias(String certAlias) {
            if (certAlias != null) {
                this.sslContextParameters.setCertAlias(certAlias);
            }
            return this;
        }

        public SSLContextBuilder cipherSuites(CipherSuitesParameters cipherSuites) {
            if (cipherSuites != null) {
                this.sslContextParameters.setCipherSuites(cipherSuites);
            }
            return this;
        }

        public SSLContextBuilder cipherSuitesFilter(FilterParameters cipherSuitesFilter) {
            if (cipherSuitesFilter != null) {
                this.sslContextParameters.setCipherSuitesFilter(cipherSuitesFilter);
            }
            return this;
        }

        public SSLContextBuilder clientParameters(SSLContextClientParameters clientParameters) {
            if (clientParameters != null) {
                this.sslContextParameters.setClientParameters(clientParameters);
            }
            return this;
        }

        public SSLContextBuilder keyManagers(KeyManagersParameters keyManagers) {
            if (keyManagers != null) {
                this.sslContextParameters.setKeyManagers(keyManagers);
            }
            return this;
        }

        public SSLContextBuilder provider(String provider) {
            if (provider != null) {
                this.sslContextParameters.setProvider(provider);
            }
            return this;
        }

        public SSLContextBuilder secureRandom(SecureRandomParameters secureRandom) {
            if (secureRandom != null) {
                this.sslContextParameters.setSecureRandom(secureRandom);
            }
            return this;
        }

        public SSLContextBuilder secureSocketProtocol(String secureSocketProtocol) {
            if (secureSocketProtocol != null) {
                this.sslContextParameters.setSecureSocketProtocol(secureSocketProtocol);
            }
            return this;
        }

        public SSLContextBuilder secureSocketProtocols(SecureSocketProtocolsParameters secureSocketProtocols) {
            if (secureSocketProtocols != null) {
                this.sslContextParameters.setSecureSocketProtocols(secureSocketProtocols);
            }
            return this;
        }

        public SSLContextBuilder secureSocketProtocolsFilter(FilterParameters secureSocketProtocolsFilter) {
            if (secureSocketProtocolsFilter != null) {
                this.sslContextParameters.setSecureSocketProtocolsFilter(secureSocketProtocolsFilter);
            }
            return this;
        }

        public SSLContextBuilder serverParameters(SSLContextServerParameters serverParameters) {
            if (serverParameters != null) {
                this.sslContextParameters.setServerParameters(serverParameters);
            }
            return this;
        }

        public SSLContextBuilder sessionTimeout(String sessionTimeout) {
            if (sessionTimeout != null) {
                this.sslContextParameters.setSessionTimeout(sessionTimeout);
            }
            return this;
        }

        public SSLContextBuilder trustManager(TrustManagersParameters trustManager) {
            if (trustManager != null) {
                this.sslContextParameters.setTrustManagers(trustManager);
            }
            return this;
        }

        public SSLContextParameters build() {
            return this.sslContextParameters;
        }
    }

    public static class SSLConfigCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata annotatedTypeMetadata) {
            Binder binder = Binder.get((Environment)context.getEnvironment());
            Map sslProperties = (Map)binder.bind("camel.ssl.config", Bindable.mapOf(String.class, Object.class)).orElse(Collections.emptyMap());
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.ssl.config", (Object[])new Object[0]);
            if (!sslProperties.isEmpty()) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }
    }

    public static class SSLCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata annotatedTypeMetadata) {
            Binder binder = Binder.get((Environment)context.getEnvironment());
            Map sslProperties = (Map)binder.bind("camel.ssl", Bindable.mapOf(String.class, Object.class)).orElse(Collections.emptyMap());
            sslProperties.remove("config");
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"camel.ssl", (Object[])new Object[0]);
            if (sslProperties.size() > 0) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }
    }
}

