/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.support.TypeConverterSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;

public class SpringTypeConverter
extends TypeConverterSupport {
    private final List<ConversionService> conversionServices;
    private final ConcurrentHashMap<Class<?>, TypeDescriptor> types;

    @Autowired
    public SpringTypeConverter(List<ConversionService> conversionServices) {
        this.conversionServices = conversionServices;
        this.types = new ConcurrentHashMap();
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
        if (type.getCanonicalName().startsWith("org.apache")) {
            return null;
        }
        if (type.isAssignableFrom(Map.class) && this.isArrayOrCollection(value)) {
            return null;
        }
        TypeDescriptor sourceType = this.types.computeIfAbsent(value.getClass(), TypeDescriptor::valueOf);
        TypeDescriptor targetType = this.types.computeIfAbsent(type, TypeDescriptor::valueOf);
        for (ConversionService conversionService : this.conversionServices) {
            if (!conversionService.canConvert(sourceType, targetType)) continue;
            try {
                return (T)conversionService.convert(value, sourceType, targetType);
            }
            catch (ConversionFailedException e) {
                if (e.getCause() instanceof ConverterNotFoundException && this.isArrayOrCollection(value)) {
                    return null;
                }
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }
        return null;
    }

    private boolean isArrayOrCollection(Object value) {
        return value instanceof Collection || value.getClass().isArray();
    }
}

