/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.util;

import java.util.List;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;

public class CompositeConversionService
implements ConversionService {
    private final List<ConversionService> delegates;

    public CompositeConversionService(List<ConversionService> delegates) {
        this.delegates = delegates;
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        for (ConversionService service : this.delegates) {
            if (!service.canConvert(sourceType, targetType)) continue;
            return true;
        }
        return false;
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (ConversionService service : this.delegates) {
            if (!service.canConvert(sourceType, targetType)) continue;
            return true;
        }
        return false;
    }

    public <T> T convert(Object source, Class<T> targetType) {
        for (int i = 0; i < this.delegates.size() - 1; ++i) {
            try {
                ConversionService delegate = this.delegates.get(i);
                if (!delegate.canConvert(source.getClass(), targetType)) continue;
                return (T)delegate.convert(source, targetType);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        return (T)this.delegates.get(this.delegates.size() - 1).convert(source, targetType);
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (int i = 0; i < this.delegates.size() - 1; ++i) {
            try {
                ConversionService delegate = this.delegates.get(i);
                if (!delegate.canConvert(sourceType, targetType)) continue;
                return delegate.convert(source, sourceType, targetType);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        return this.delegates.get(this.delegates.size() - 1).convert(source, sourceType, targetType);
    }
}

