/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.camel.health.HealthCheck;
import org.springframework.boot.actuate.health.Health;

final class CamelHealthHelper {
    private CamelHealthHelper() {
    }

    public static void applyHealthDetail(Health.Builder builder, HealthCheck.Result result, String exposureLevel) {
        if (!exposureLevel.equals("oneline")) {
            HealthCheck check = result.getCheck();
            Set metaKeys = check.getMetaData().keySet();
            LinkedHashMap data = new LinkedHashMap();
            result.getDetails().forEach((key, value) -> {
                if (value != null) {
                    if (exposureLevel.equals("full")) {
                        data.put(key, value.toString());
                    } else if (!metaKeys.contains(key)) {
                        data.put(key, value.toString());
                    }
                }
            });
            result.getError().ifPresent(error -> {
                builder.withDetail("error.message", (Object)error.getMessage());
                StringWriter stackTraceWriter = new StringWriter();
                try (PrintWriter pw = new PrintWriter((Writer)stackTraceWriter, true);){
                    error.printStackTrace(pw);
                    data.put("error.stacktrace", stackTraceWriter.toString());
                }
            });
            if (!data.isEmpty()) {
                String id = result.getCheck().getId() + ".data";
                builder.withDetail(id, data);
            }
        }
    }
}

