/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.StartupListener;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.main.SimpleMainShutdownStrategy;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelMainRunController;
import org.apache.camel.spring.boot.CamelSpringBootInitializationException;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class CamelSpringBootApplicationListener
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringBootApplicationListener.class);
    private final ApplicationContext applicationContext;
    private final List<CamelContextConfiguration> camelContextConfigurations;
    private final CamelConfigurationProperties configurationProperties;
    private final RoutesCollector springBootRoutesCollector;

    public CamelSpringBootApplicationListener(ApplicationContext applicationContext, List<CamelContextConfiguration> camelContextConfigurations, CamelConfigurationProperties configurationProperties, RoutesCollector springBootRoutesCollector) {
        this.applicationContext = applicationContext;
        this.camelContextConfigurations = new ArrayList<CamelContextConfiguration>(camelContextConfigurations);
        this.configurationProperties = configurationProperties;
        this.springBootRoutesCollector = springBootRoutesCollector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onApplicationEvent(ContextRefreshedEvent event) {
        final CamelContext camelContext = (CamelContext)this.applicationContext.getBean(CamelContext.class);
        if (event.getApplicationContext() == this.applicationContext && camelContext.getStatus().isStopped()) {
            LOG.debug("Post-processing CamelContext bean: {}", (Object)camelContext.getName());
            RoutesConfigurer configurer = new RoutesConfigurer(camelContext);
            try {
                ServiceHelper.startService((Service)configurer);
                if (this.configurationProperties.getMain().isRoutesCollectorEnabled()) {
                    configurer.setRoutesCollector(this.springBootRoutesCollector);
                }
                configurer.setBeanPostProcessor(PluginHelper.getBeanPostProcessor((CamelContext)camelContext));
                configurer.setJavaRoutesExcludePattern(this.configurationProperties.getMain().getJavaRoutesExcludePattern());
                configurer.setJavaRoutesIncludePattern(this.configurationProperties.getMain().getJavaRoutesIncludePattern());
                configurer.setRoutesExcludePattern(this.configurationProperties.getMain().getRoutesExcludePattern());
                configurer.setRoutesIncludePattern(this.configurationProperties.getMain().getRoutesIncludePattern());
                configurer.configureRoutes(camelContext);
                for (CamelContextConfiguration camelContextConfiguration : this.camelContextConfigurations) {
                    LOG.debug("CamelContextConfiguration found. Invoking beforeApplicationStart: {}", (Object)camelContextConfiguration);
                    camelContextConfiguration.beforeApplicationStart(camelContext);
                }
                if (this.configurationProperties.getMain().isRunController() || this.configurationProperties.getMain().isMainRunController()) {
                    final CamelMainRunController controller = new CamelMainRunController(this.applicationContext, camelContext);
                    if (this.configurationProperties.getMain().getDurationMaxMessages() > 0 || this.configurationProperties.getMain().getDurationMaxIdleSeconds() > 0) {
                        if (this.configurationProperties.getMain().getDurationMaxMessages() > 0) {
                            LOG.info("CamelSpringBoot will terminate after processing {} messages", (Object)this.configurationProperties.getMain().getDurationMaxMessages());
                        }
                        if (this.configurationProperties.getMain().getDurationMaxIdleSeconds() > 0) {
                            LOG.info("CamelSpringBoot will terminate after being idle for more {} seconds", (Object)this.configurationProperties.getMain().getDurationMaxIdleSeconds());
                        }
                        MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.configurationProperties.getMain().getDurationMaxMessages(), (long)this.configurationProperties.getMain().getDurationMaxIdleSeconds(), controller.getMainShutdownStrategy(), true, this.configurationProperties.getMain().isRoutesReloadRestartDuration(), this.configurationProperties.getMain().getDurationMaxAction());
                        ServiceHelper.startService((Object)notifier);
                        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
                    }
                    if (this.configurationProperties.getMain().getDurationMaxSeconds() > 0) {
                        LOG.info("CamelSpringBoot will terminate after {} seconds", (Object)this.configurationProperties.getMain().getDurationMaxSeconds());
                        this.terminateMainControllerAfter(camelContext, this.configurationProperties.getMain().getDurationMaxSeconds(), controller.getMainShutdownStrategy(), controller.getMainCompleteTask());
                    }
                    camelContext.addStartupListener(new StartupListener(){

                        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
                            if (!alreadyStarted) {
                                LOG.info("Starting CamelMainRunController to ensure the main thread keeps running");
                                controller.start();
                            }
                        }
                    });
                } else if (this.applicationContext instanceof ConfigurableApplicationContext) {
                    ConfigurableApplicationContext cac = (ConfigurableApplicationContext)this.applicationContext;
                    if (this.configurationProperties.getMain().getDurationMaxSeconds() > 0) {
                        LOG.info("CamelSpringBoot will terminate after {} seconds", (Object)this.configurationProperties.getMain().getDurationMaxSeconds());
                        this.terminateApplicationContext(cac, camelContext, this.configurationProperties.getMain().getDurationMaxSeconds());
                    }
                    if (this.configurationProperties.getMain().getDurationMaxMessages() > 0 || this.configurationProperties.getMain().getDurationMaxIdleSeconds() > 0) {
                        if (this.configurationProperties.getMain().getDurationMaxMessages() > 0) {
                            LOG.info("CamelSpringBoot will terminate after processing {} messages", (Object)this.configurationProperties.getMain().getDurationMaxMessages());
                        }
                        if (this.configurationProperties.getMain().getDurationMaxIdleSeconds() > 0) {
                            LOG.info("CamelSpringBoot will terminate after being idle for more {} seconds", (Object)this.configurationProperties.getMain().getDurationMaxIdleSeconds());
                        }
                        SimpleMainShutdownStrategy strategy = new SimpleMainShutdownStrategy();
                        MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.configurationProperties.getMain().getDurationMaxMessages(), (long)this.configurationProperties.getMain().getDurationMaxIdleSeconds(), (MainShutdownStrategy)strategy, false, this.configurationProperties.getMain().isRoutesReloadRestartDuration(), this.configurationProperties.getMain().getDurationMaxAction());
                        ServiceHelper.startService((Object)notifier);
                        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
                        this.terminateApplicationContext(cac, camelContext, (MainShutdownStrategy)strategy);
                    }
                }
                if (this.camelContextConfigurations.isEmpty()) return;
                camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

                    public void notify(CamelEvent eventObject) throws Exception {
                        for (CamelContextConfiguration camelContextConfiguration : CamelSpringBootApplicationListener.this.camelContextConfigurations) {
                            LOG.debug("CamelContextConfiguration found. Invoking afterApplicationStart: {}", (Object)camelContextConfiguration);
                            try {
                                camelContextConfiguration.afterApplicationStart(camelContext);
                            }
                            catch (Exception e) {
                                LOG.warn("Error during calling afterApplicationStart due {}. This exception is ignored", (Object)e.getMessage(), (Object)e);
                            }
                        }
                    }

                    public boolean isEnabled(CamelEvent eventObject) {
                        return eventObject.getType() == CamelEvent.Type.CamelContextStarted;
                    }
                });
                return;
            }
            catch (Exception e) {
                throw new CamelSpringBootInitializationException(e);
            }
            finally {
                ServiceHelper.stopService((Service)configurer);
            }
        } else {
            LOG.debug("Camel already started, not adding routes.");
        }
    }

    public int getOrder() {
        return 0x7FFFFFFD;
    }

    private void terminateMainControllerAfter(CamelContext camelContext, int seconds, final MainShutdownStrategy shutdownStrategy, final Runnable mainCompletedTask) {
        ScheduledExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "CamelSpringBootTerminateTask");
        final AtomicBoolean running = new AtomicBoolean();
        Runnable task = () -> {
            Runnable stop = () -> {
                running.set(true);
                LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
                try {
                    camelContext.stop();
                }
                catch (Throwable e) {
                    LOG.warn("Error during stopping CamelContext", e);
                }
                finally {
                    shutdownStrategy.shutdown();
                    mainCompletedTask.run();
                }
                running.set(false);
            };
            new Thread(stop, "CamelSpringBootTerminateTaskWorker").start();
        };
        final ScheduledFuture<?> future = executorService.schedule(task, (long)seconds, TimeUnit.SECONDS);
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(this){

            public void onContextStopping(CamelContext context) {
                if (!running.get()) {
                    future.cancel(true);
                    shutdownStrategy.shutdown();
                    mainCompletedTask.run();
                }
            }
        });
    }

    private void terminateApplicationContext(ConfigurableApplicationContext applicationContext, CamelContext camelContext, int seconds) {
        ScheduledExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "CamelSpringBootTerminateTask");
        final AtomicBoolean running = new AtomicBoolean();
        Runnable task = () -> {
            Runnable stop = () -> {
                running.set(true);
                LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
                new Thread(() -> ((ConfigurableApplicationContext)applicationContext).close()).start();
                running.set(false);
            };
            new Thread(stop, "CamelSpringBootTerminateTaskWorker").start();
        };
        final ScheduledFuture<?> future = executorService.schedule(task, (long)seconds, TimeUnit.SECONDS);
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(this){

            public void onContextStopping(CamelContext context) {
                if (!running.get()) {
                    future.cancel(true);
                }
            }
        });
    }

    private void terminateApplicationContext(ConfigurableApplicationContext applicationContext, CamelContext camelContext, final MainShutdownStrategy shutdownStrategy) {
        ExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "CamelSpringBootTerminateTask");
        final AtomicBoolean running = new AtomicBoolean();
        Runnable task = () -> {
            try {
                shutdownStrategy.await();
                running.set(true);
                LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
                new Thread(() -> ((ConfigurableApplicationContext)applicationContext).close()).start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            running.set(false);
        };
        final Future<?> future = executorService.submit(task);
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(this){

            public void onContextStopping(CamelContext context) {
                if (!running.get()) {
                    future.cancel(true);
                } else {
                    shutdownStrategy.shutdown();
                }
            }
        });
    }
}

