/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.aot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.util.ClassUtils;

public final class RuntimeHintsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeHintsHelper.class);

    private RuntimeHintsHelper() {
    }

    public static void registerClassHierarchy(RuntimeHints hints, ClassLoader classLoader, String className, MemberCategory ... memberCategories) {
        try {
            RuntimeHintsHelper.registerClassHierarchy(hints, ClassUtils.forName((String)className, (ClassLoader)classLoader), memberCategories);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.debug("The class {} cannot be found", (Object)className);
        }
    }

    public static void registerClassHierarchy(RuntimeHints hints, Class<?> clazz, MemberCategory ... memberCategories) {
        if (clazz.isInterface() || clazz.isArray()) {
            return;
        }
        while (clazz != Object.class) {
            hints.reflection().registerType(clazz, memberCategories);
            clazz = clazz.getSuperclass();
        }
    }
}

