/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import jakarta.annotation.PreDestroy;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.main.Main;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.main.SimpleMainShutdownStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CamelSpringBootApplicationController
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringBootApplicationController.class);
    private final CamelSpringMain main;
    private CamelContext camelContext;

    public CamelSpringBootApplicationController(ApplicationContext applicationContext) {
        this.main = new CamelSpringMain(applicationContext, this);
        Map listeners = applicationContext.getBeansOfType(MainListener.class);
        for (MainListener listener : listeners.values()) {
            this.main.addMainListener(listener);
        }
    }

    public Main getMain() {
        return this.main;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public MainShutdownStrategy getMainShutdownStrategy() {
        return this.main.getShutdownStrategy();
    }

    public Runnable getMainCompletedTask() {
        return this.main.getCompleteTask();
    }

    public void run() {
        LOG.debug("Controller is starting and waiting for Spring-Boot to stop or JVM to terminate");
        try {
            this.main.run();
            LOG.debug("Waiting for CamelContext to complete shutdown");
            this.main.getShutdownStrategy().await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.debug("CamelContext shutdown complete.");
    }

    @Deprecated
    public void blockMainThread() {
        this.run();
    }

    @PreDestroy
    void destroy() {
        this.main.completed();
    }

    private static class CamelSpringMain
    extends Main {
        final ApplicationContext applicationContext;
        final CamelSpringBootApplicationController controller;

        public CamelSpringMain(ApplicationContext applicationContext, CamelSpringBootApplicationController controller) {
            this.applicationContext = applicationContext;
            this.controller = controller;
            this.shutdownStrategy = new SimpleMainShutdownStrategy();
            this.mainConfigurationProperties.setRoutesCollectorEnabled(false);
        }

        protected ProducerTemplate findOrCreateCamelTemplate() {
            return (ProducerTemplate)this.applicationContext.getBean(ProducerTemplate.class);
        }

        protected CamelContext createCamelContext() {
            return this.controller.camelContext;
        }

        protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        }
    }
}

