/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.List;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.MainListener;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringBootCamelContext
extends SpringCamelContext {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootCamelContext.class);
    private final StopWatch stopWatch = new StopWatch();
    private final boolean warnOnEarlyShutdown;
    private final CamelSpringBootApplicationController controller;

    public SpringBootCamelContext(ApplicationContext applicationContext, boolean warnOnEarlyShutdown, CamelSpringBootApplicationController controller) {
        super(applicationContext);
        this.warnOnEarlyShutdown = warnOnEarlyShutdown;
        this.controller = controller;
    }

    protected void doStart() throws Exception {
        List listeners = this.controller.getMain().getMainListeners();
        if (!listeners.isEmpty()) {
            for (MainListener listener : listeners) {
                listener.beforeStart((BaseMainSupport)this.controller.getMain());
            }
        }
        this.stopWatch.restart();
        super.doStart();
        if (!listeners.isEmpty()) {
            for (MainListener listener : listeners) {
                listener.afterStart((BaseMainSupport)this.controller.getMain());
            }
        }
    }

    protected synchronized void doStop() throws Exception {
        List listeners = this.controller.getMain().getMainListeners();
        if (!listeners.isEmpty()) {
            for (MainListener listener : listeners) {
                listener.beforeStop((BaseMainSupport)this.controller.getMain());
            }
        }
        long taken = this.stopWatch.taken();
        if (this.warnOnEarlyShutdown && taken < 1200L) {
            boolean starterWeb;
            String cp = System.getProperty("java.class.path");
            boolean junit = cp != null && cp.contains("junit-");
            boolean bl = starterWeb = cp != null && cp.contains("spring-boot-starter-web");
            if (!junit && !starterWeb) {
                LOG.warn("CamelContext has only been running for less than a second. If you intend to run Camel for a longer time then you can set the property camel.springboot.main-run-controller=true in application.properties or add spring-boot-starter-web JAR to the classpath.");
            }
        }
        super.doStop();
        if (!listeners.isEmpty()) {
            for (MainListener listener : listeners) {
                listener.afterStop((BaseMainSupport)this.controller.getMain());
            }
        }
    }
}

