/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ManagementMBeansLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="camel")
public class CamelConfigurationProperties {
    @NestedConfigurationProperty
    private final Springboot springboot = new Springboot();
    @NestedConfigurationProperty
    private final Main main = new Main();

    public Springboot getSpringboot() {
        return this.springboot;
    }

    public Main getMain() {
        return this.main;
    }

    public class Springboot
    extends InnerDeprecatedCamelConfigurationProperties {
        private boolean mainRunController;
        private boolean includeNonSingletons;
        private boolean warnOnEarlyShutdown;

        public Springboot() {
            this.warnOnEarlyShutdown = true;
        }

        public boolean isMainRunController() {
            return this.mainRunController;
        }

        public void setMainRunController(boolean mainRunController) {
            this.mainRunController = mainRunController;
        }

        public boolean isIncludeNonSingletons() {
            return this.includeNonSingletons;
        }

        public void setIncludeNonSingletons(boolean includeNonSingletons) {
            this.includeNonSingletons = includeNonSingletons;
        }

        public boolean isWarnOnEarlyShutdown() {
            return this.warnOnEarlyShutdown;
        }

        public void setWarnOnEarlyShutdown(boolean warnOnEarlyShutdown) {
            this.warnOnEarlyShutdown = warnOnEarlyShutdown;
        }
    }

    public class Main
    extends InnerCamelConfigurationProperties {
    }

    static class InnerCamelConfigurationProperties
    extends DefaultConfigurationProperties {
        private String name;
        private String description;
        private StartupSummaryLevel startupSummaryLevel;
        private int durationMaxSeconds;
        private int durationMaxIdleSeconds;
        private int durationMaxMessages;
        private String durationMaxAction = "shutdown";
        private int shutdownTimeout = 45;
        private boolean shutdownSuppressLoggingOnTimeout;
        private boolean shutdownNowOnTimeout = true;
        private boolean shutdownRoutesInReverseOrder = true;
        private boolean shutdownLogInflightExchangesOnTimeout = true;
        private boolean inflightRepositoryBrowseEnabled;
        private String fileConfigurations;
        private boolean jmxEnabled = true;
        private String uuidGenerator = "default";
        private int producerTemplateCacheSize = 1000;
        private int consumerTemplateCacheSize = 1000;
        private boolean loadTypeConverters;
        private boolean loadHealthChecks;
        private boolean devConsoleEnabled;
        @Deprecated(since="4.10")
        private boolean modeline;
        private int logDebugMaxChars;
        private boolean streamCachingEnabled = true;
        private String streamCachingAllowClasses;
        private String streamCachingDenyClasses;
        private boolean streamCachingSpoolEnabled;
        private String streamCachingSpoolDirectory;
        private String streamCachingSpoolCipher;
        private long streamCachingSpoolThreshold;
        private int streamCachingSpoolUsedHeapMemoryThreshold;
        private String streamCachingSpoolUsedHeapMemoryLimit;
        private boolean streamCachingAnySpoolRules;
        private int streamCachingBufferSize;
        private boolean streamCachingRemoveSpoolDirectoryWhenStopping = true;
        private boolean streamCachingStatisticsEnabled;
        private boolean typeConverterStatisticsEnabled;
        private boolean tracing;
        private boolean tracingStandby;
        private boolean tracingTemplates;
        private String tracingPattern;
        private String tracingLoggingFormat;
        private boolean messageHistory;
        private boolean sourceLocationEnabled;
        private boolean logMask;
        private boolean logExhaustedMessageBody;
        private String logName;
        private String logLanguage;
        private boolean autoStartup = true;
        private String autoStartupExcludePattern;
        private boolean allowUseOriginalMessage;
        private boolean caseInsensitiveHeaders = true;
        private boolean autowiredEnabled = true;
        private boolean endpointRuntimeStatisticsEnabled;
        private boolean loadStatisticsEnabled;
        private boolean endpointLazyStartProducer;
        private boolean endpointBridgeErrorHandler;
        private boolean useDataType;
        private boolean useBreadcrumb;
        private boolean beanPostProcessorEnabled = true;
        private ManagementMBeansLevel jmxManagementMBeansLevel = ManagementMBeansLevel.Default;
        private ManagementStatisticsLevel jmxManagementStatisticsLevel = ManagementStatisticsLevel.Default;
        private String jmxManagementNamePattern = "#name#";
        private boolean jmxManagementRegisterRoutesCreateByKamelet;
        private boolean jmxManagementRegisterRoutesCreateByTemplate = true;
        private boolean camelEventsTimestampEnabled;
        private boolean useMdcLogging;
        private String mdcLoggingKeysPattern;
        private String threadNamePattern;
        private String routeFilterIncludePattern;
        private String routeFilterExcludePattern;
        private boolean beanIntrospectionExtendedStatistics;
        private LoggingLevel beanIntrospectionLoggingLevel;
        private boolean routesCollectorEnabled = true;
        private boolean routesCollectorIgnoreLoadingError;
        private String compileWorkDir;
        private String javaRoutesIncludePattern;
        private String javaRoutesExcludePattern;
        private String routesIncludePattern = "classpath:camel/*,classpath:camel-template/*,classpath:camel-rest/*";
        private String routesExcludePattern;
        private boolean routesReloadEnabled;
        private boolean contextReloadEnabled;
        private String routesReloadDirectory = "src/main/resources/camel";
        private boolean routesReloadDirectoryRecursive;
        private String routesReloadPattern;
        private boolean routesReloadRemoveAllRoutes = true;
        private boolean routesReloadRestartDuration;
        private boolean jmxUpdateRouteEnabled;
        private String exchangeFactory = "default";
        private int exchangeFactoryCapacity = 100;
        private boolean exchangeFactoryStatisticsEnabled;
        private String dumpRoutes;
        private String dumpRoutesInclude = "routes";
        private boolean dumpRoutesLog = true;
        private boolean dumpRoutesResolvePlaceholders = true;
        private boolean dumpRoutesUriAsParameters;
        private boolean dumpRoutesGeneratedIds;
        private String dumpRoutesOutput;
        private Map globalOptions;
        private String startupRecorder;
        private int startupRecorderMaxDepth = -1;
        private boolean startupRecorderRecording;
        private String startupRecorderProfile = "default";
        private long startupRecorderDuration;
        private String startupRecorderDir;
        private String cloudPropertiesLocation;

        InnerCamelConfigurationProperties() {
        }
    }

    class InnerDeprecatedCamelConfigurationProperties
    extends InnerCamelConfigurationProperties {
        InnerDeprecatedCamelConfigurationProperties() {
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.name", since="4.5.0")
        @Deprecated
        public String getName() {
            return CamelConfigurationProperties.this.main.getName();
        }

        @Deprecated
        public void setName(String name) {
            CamelConfigurationProperties.this.main.setName(name);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.description", since="4.5.0")
        @Deprecated
        public String getDescription() {
            return CamelConfigurationProperties.this.main.getDescription();
        }

        @Deprecated
        public void setDescription(String description) {
            CamelConfigurationProperties.this.main.setDescription(description);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.startup-summary-level", since="4.5.0")
        @Deprecated
        public StartupSummaryLevel getStartupSummaryLevel() {
            return CamelConfigurationProperties.this.main.getStartupSummaryLevel();
        }

        @Deprecated
        public void setStartupSummaryLevel(StartupSummaryLevel startupSummaryLevel) {
            CamelConfigurationProperties.this.main.setStartupSummaryLevel(startupSummaryLevel);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.duration-max-seconds", since="4.5.0")
        @Deprecated
        public int getDurationMaxSeconds() {
            return CamelConfigurationProperties.this.main.getDurationMaxSeconds();
        }

        @Deprecated
        public void setDurationMaxSeconds(int durationMaxSeconds) {
            CamelConfigurationProperties.this.main.setDurationMaxSeconds(durationMaxSeconds);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.duration-max-idle-seconds", since="4.5.0")
        @Deprecated
        public int getDurationMaxIdleSeconds() {
            return CamelConfigurationProperties.this.main.getDurationMaxIdleSeconds();
        }

        @Deprecated
        public void setDurationMaxIdleSeconds(int durationMaxIdleSeconds) {
            CamelConfigurationProperties.this.main.setDurationMaxIdleSeconds(durationMaxIdleSeconds);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.duration-max-messages", since="4.5.0")
        @Deprecated
        public int getDurationMaxMessages() {
            return CamelConfigurationProperties.this.main.getDurationMaxMessages();
        }

        @Deprecated
        public void setDurationMaxMessages(int durationMaxMessages) {
            CamelConfigurationProperties.this.main.setDurationMaxMessages(durationMaxMessages);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.duration-max-action", since="4.5.0")
        @Deprecated
        public String getDurationMaxAction() {
            return CamelConfigurationProperties.this.main.getDurationMaxAction();
        }

        @Deprecated
        public void setDurationMaxAction(String durationMaxAction) {
            CamelConfigurationProperties.this.main.setDurationMaxAction(durationMaxAction);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.shutdown-timeout", since="4.5.0")
        @Deprecated
        public int getShutdownTimeout() {
            return CamelConfigurationProperties.this.main.getShutdownTimeout();
        }

        @Deprecated
        public void setShutdownTimeout(int shutdownTimeout) {
            CamelConfigurationProperties.this.main.setShutdownTimeout(shutdownTimeout);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.shutdown-suppress-logging-on-timeout", since="4.5.0")
        @Deprecated
        public boolean isShutdownSuppressLoggingOnTimeout() {
            return CamelConfigurationProperties.this.main.isShutdownSuppressLoggingOnTimeout();
        }

        @Deprecated
        public void setShutdownSuppressLoggingOnTimeout(boolean shutdownSuppressLoggingOnTimeout) {
            CamelConfigurationProperties.this.main.setShutdownSuppressLoggingOnTimeout(shutdownSuppressLoggingOnTimeout);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.shutdown-now-on-timeout", since="4.5.0")
        @Deprecated
        public boolean isShutdownNowOnTimeout() {
            return CamelConfigurationProperties.this.main.isShutdownNowOnTimeout();
        }

        @Deprecated
        public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
            CamelConfigurationProperties.this.main.setShutdownNowOnTimeout(shutdownNowOnTimeout);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.shutdown-routes-in-reverse-order", since="4.5.0")
        @Deprecated
        public boolean isShutdownRoutesInReverseOrder() {
            return CamelConfigurationProperties.this.main.isShutdownRoutesInReverseOrder();
        }

        @Deprecated
        public void setShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
            CamelConfigurationProperties.this.main.setShutdownRoutesInReverseOrder(shutdownRoutesInReverseOrder);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.shutdown-log-inflight-exchanges-on-timeout", since="4.5.0")
        @Deprecated
        public boolean isShutdownLogInflightExchangesOnTimeout() {
            return CamelConfigurationProperties.this.main.isShutdownLogInflightExchangesOnTimeout();
        }

        @Deprecated
        public void setShutdownLogInflightExchangesOnTimeout(boolean shutdownLogInflightExchangesOnTimeout) {
            CamelConfigurationProperties.this.main.setShutdownLogInflightExchangesOnTimeout(shutdownLogInflightExchangesOnTimeout);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.inflight-repository-browse-enabled", since="4.5.0")
        @Deprecated
        public boolean isInflightRepositoryBrowseEnabled() {
            return CamelConfigurationProperties.this.main.isInflightRepositoryBrowseEnabled();
        }

        @Deprecated
        public void setInflightRepositoryBrowseEnabled(boolean inflightRepositoryBrowseEnabled) {
            CamelConfigurationProperties.this.main.setInflightRepositoryBrowseEnabled(inflightRepositoryBrowseEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.file-configurations", since="4.5.0")
        @Deprecated
        public String getFileConfigurations() {
            return CamelConfigurationProperties.this.main.getFileConfigurations();
        }

        @Deprecated
        public void setFileConfigurations(String fileConfigurations) {
            CamelConfigurationProperties.this.main.setFileConfigurations(fileConfigurations);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.jmx-enabled", since="4.5.0")
        @Deprecated
        public boolean isJmxEnabled() {
            return CamelConfigurationProperties.this.main.isJmxEnabled();
        }

        @Deprecated
        public void setJmxEnabled(boolean jmxEnabled) {
            CamelConfigurationProperties.this.main.setJmxEnabled(jmxEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.uuid-generator", since="4.5.0")
        @Deprecated
        public String getUuidGenerator() {
            return CamelConfigurationProperties.this.main.getUuidGenerator();
        }

        @Deprecated
        public void setUuidGenerator(String uuidGenerator) {
            CamelConfigurationProperties.this.main.setUuidGenerator(uuidGenerator);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.producer-template-cache-size", since="4.5.0")
        @Deprecated
        public int getProducerTemplateCacheSize() {
            return CamelConfigurationProperties.this.main.getProducerTemplateCacheSize();
        }

        @Deprecated
        public void setProducerTemplateCacheSize(int producerTemplateCacheSize) {
            CamelConfigurationProperties.this.main.setProducerTemplateCacheSize(producerTemplateCacheSize);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.consumer-template-cache-size", since="4.5.0")
        @Deprecated
        public int getConsumerTemplateCacheSize() {
            return CamelConfigurationProperties.this.main.getConsumerTemplateCacheSize();
        }

        @Deprecated
        public void setConsumerTemplateCacheSize(int consumerTemplateCacheSize) {
            CamelConfigurationProperties.this.main.setConsumerTemplateCacheSize(consumerTemplateCacheSize);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.load-type-converters", since="4.5.0")
        @Deprecated
        public boolean isLoadTypeConverters() {
            return CamelConfigurationProperties.this.main.isLoadTypeConverters();
        }

        @Deprecated
        public void setLoadTypeConverters(boolean loadTypeConverters) {
            CamelConfigurationProperties.this.main.setLoadTypeConverters(loadTypeConverters);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.load-health-checks", since="4.5.0")
        @Deprecated
        public boolean isLoadHealthChecks() {
            return CamelConfigurationProperties.this.main.isLoadHealthChecks();
        }

        @Deprecated
        public void setLoadHealthChecks(boolean loadHealthChecks) {
            CamelConfigurationProperties.this.main.setLoadHealthChecks(loadHealthChecks);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.dev-console-enabled", since="4.5.0")
        @Deprecated
        public boolean isDevConsoleEnabled() {
            return CamelConfigurationProperties.this.main.isDevConsoleEnabled();
        }

        @Deprecated
        public void setDevConsoleEnabled(boolean devConsoleEnabled) {
            CamelConfigurationProperties.this.main.setDevConsoleEnabled(devConsoleEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.modeline", since="4.5.0")
        @Deprecated
        public boolean isModeline() {
            return CamelConfigurationProperties.this.main.isModeline();
        }

        @Deprecated
        public void setModeline(boolean modeline) {
            CamelConfigurationProperties.this.main.setModeline(modeline);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.log-debug-max-chars", since="4.5.0")
        @Deprecated
        public int getLogDebugMaxChars() {
            return CamelConfigurationProperties.this.main.getLogDebugMaxChars();
        }

        @Deprecated
        public void setLogDebugMaxChars(int logDebugMaxChars) {
            CamelConfigurationProperties.this.main.setLogDebugMaxChars(logDebugMaxChars);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-enabled", since="4.5.0")
        @Deprecated
        public boolean isStreamCachingEnabled() {
            return CamelConfigurationProperties.this.main.isStreamCachingEnabled();
        }

        @Deprecated
        public void setStreamCachingEnabled(boolean streamCachingEnabled) {
            CamelConfigurationProperties.this.main.setStreamCachingEnabled(streamCachingEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-allow-classes", since="4.5.0")
        @Deprecated
        public String getStreamCachingAllowClasses() {
            return CamelConfigurationProperties.this.main.getStreamCachingAllowClasses();
        }

        @Deprecated
        public void setStreamCachingAllowClasses(String streamCachingAllowClasses) {
            CamelConfigurationProperties.this.main.setStreamCachingAllowClasses(streamCachingAllowClasses);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-deny-classes", since="4.5.0")
        @Deprecated
        public String getStreamCachingDenyClasses() {
            return CamelConfigurationProperties.this.main.getStreamCachingDenyClasses();
        }

        @Deprecated
        public void setStreamCachingDenyClasses(String streamCachingDenyClasses) {
            CamelConfigurationProperties.this.main.setStreamCachingDenyClasses(streamCachingDenyClasses);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-spool-enabled", since="4.5.0")
        @Deprecated
        public boolean isStreamCachingSpoolEnabled() {
            return CamelConfigurationProperties.this.main.isStreamCachingSpoolEnabled();
        }

        @Deprecated
        public void setStreamCachingSpoolEnabled(boolean streamCachingSpoolEnabled) {
            CamelConfigurationProperties.this.main.setStreamCachingSpoolEnabled(streamCachingSpoolEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-spool-directory", since="4.5.0")
        @Deprecated
        public String getStreamCachingSpoolDirectory() {
            return CamelConfigurationProperties.this.main.getStreamCachingSpoolDirectory();
        }

        @Deprecated
        public void setStreamCachingSpoolDirectory(String streamCachingSpoolDirectory) {
            CamelConfigurationProperties.this.main.setStreamCachingSpoolDirectory(streamCachingSpoolDirectory);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-spool-cipher", since="4.5.0")
        @Deprecated
        public String getStreamCachingSpoolCipher() {
            return CamelConfigurationProperties.this.main.getStreamCachingSpoolCipher();
        }

        @Deprecated
        public void setStreamCachingSpoolCipher(String streamCachingSpoolCipher) {
            CamelConfigurationProperties.this.main.setStreamCachingSpoolCipher(streamCachingSpoolCipher);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-spool-threshold", since="4.5.0")
        @Deprecated
        public long getStreamCachingSpoolThreshold() {
            return CamelConfigurationProperties.this.main.getStreamCachingSpoolThreshold();
        }

        @Deprecated
        public void setStreamCachingSpoolThreshold(long streamCachingSpoolThreshold) {
            CamelConfigurationProperties.this.main.setStreamCachingSpoolThreshold(streamCachingSpoolThreshold);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-spool-used-heap-memory-threshold", since="4.5.0")
        @Deprecated
        public int getStreamCachingSpoolUsedHeapMemoryThreshold() {
            return CamelConfigurationProperties.this.main.getStreamCachingSpoolUsedHeapMemoryThreshold();
        }

        @Deprecated
        public void setStreamCachingSpoolUsedHeapMemoryThreshold(int streamCachingSpoolUsedHeapMemoryThreshold) {
            CamelConfigurationProperties.this.main.setStreamCachingSpoolUsedHeapMemoryThreshold(streamCachingSpoolUsedHeapMemoryThreshold);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-spool-used-heap-memory-limit", since="4.5.0")
        @Deprecated
        public String getStreamCachingSpoolUsedHeapMemoryLimit() {
            return CamelConfigurationProperties.this.main.getStreamCachingSpoolUsedHeapMemoryLimit();
        }

        @Deprecated
        public void setStreamCachingSpoolUsedHeapMemoryLimit(String streamCachingSpoolUsedHeapMemoryLimit) {
            CamelConfigurationProperties.this.main.setStreamCachingSpoolUsedHeapMemoryLimit(streamCachingSpoolUsedHeapMemoryLimit);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-any-spool-rules", since="4.5.0")
        @Deprecated
        public boolean isStreamCachingAnySpoolRules() {
            return CamelConfigurationProperties.this.main.isStreamCachingAnySpoolRules();
        }

        @Deprecated
        public void setStreamCachingAnySpoolRules(boolean streamCachingAnySpoolRules) {
            CamelConfigurationProperties.this.main.setStreamCachingAnySpoolRules(streamCachingAnySpoolRules);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-buffer-size", since="4.5.0")
        @Deprecated
        public int getStreamCachingBufferSize() {
            return CamelConfigurationProperties.this.main.getStreamCachingBufferSize();
        }

        @Deprecated
        public void setStreamCachingBufferSize(int streamCachingBufferSize) {
            CamelConfigurationProperties.this.main.setStreamCachingBufferSize(streamCachingBufferSize);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-remove-spool-directory-when-stopping", since="4.5.0")
        @Deprecated
        public boolean isStreamCachingRemoveSpoolDirectoryWhenStopping() {
            return CamelConfigurationProperties.this.main.isStreamCachingRemoveSpoolDirectoryWhenStopping();
        }

        @Deprecated
        public void setStreamCachingRemoveSpoolDirectoryWhenStopping(boolean streamCachingRemoveSpoolDirectoryWhenStopping) {
            CamelConfigurationProperties.this.main.setStreamCachingRemoveSpoolDirectoryWhenStopping(streamCachingRemoveSpoolDirectoryWhenStopping);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.stream-caching-statistics-enabled", since="4.5.0")
        @Deprecated
        public boolean isStreamCachingStatisticsEnabled() {
            return CamelConfigurationProperties.this.main.isStreamCachingStatisticsEnabled();
        }

        @Deprecated
        public void setStreamCachingStatisticsEnabled(boolean streamCachingStatisticsEnabled) {
            CamelConfigurationProperties.this.main.setStreamCachingStatisticsEnabled(streamCachingStatisticsEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.type-converter-statistics-enabled", since="4.5.0")
        @Deprecated
        public boolean isTypeConverterStatisticsEnabled() {
            return CamelConfigurationProperties.this.main.isTypeConverterStatisticsEnabled();
        }

        @Deprecated
        public void setTypeConverterStatisticsEnabled(boolean typeConverterStatisticsEnabled) {
            CamelConfigurationProperties.this.main.setTypeConverterStatisticsEnabled(typeConverterStatisticsEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.tracing", since="4.5.0")
        @Deprecated
        public boolean isTracing() {
            return CamelConfigurationProperties.this.main.isTracing();
        }

        @Deprecated
        public void setTracing(boolean tracing) {
            CamelConfigurationProperties.this.main.setTracing(tracing);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.tracing-standby", since="4.5.0")
        @Deprecated
        public boolean isTracingStandby() {
            return CamelConfigurationProperties.this.main.isTracingStandby();
        }

        @Deprecated
        public void setTracingStandby(boolean tracingStandby) {
            CamelConfigurationProperties.this.main.setTracingStandby(tracingStandby);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.tracing-templates", since="4.5.0")
        @Deprecated
        public boolean isTracingTemplates() {
            return CamelConfigurationProperties.this.main.isTracingTemplates();
        }

        @Deprecated
        public void setTracingTemplates(boolean tracingTemplates) {
            CamelConfigurationProperties.this.main.setTracingTemplates(tracingTemplates);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.tracing-pattern", since="4.5.0")
        @Deprecated
        public String getTracingPattern() {
            return CamelConfigurationProperties.this.main.getTracingPattern();
        }

        @Deprecated
        public void setTracingPattern(String tracingPattern) {
            CamelConfigurationProperties.this.main.setTracingPattern(tracingPattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.tracing-logging-format", since="4.5.0")
        @Deprecated
        public String getTracingLoggingFormat() {
            return CamelConfigurationProperties.this.main.getTracingLoggingFormat();
        }

        @Deprecated
        public void setTracingLoggingFormat(String tracingLoggingFormat) {
            CamelConfigurationProperties.this.main.setTracingLoggingFormat(tracingLoggingFormat);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.message-history", since="4.5.0")
        @Deprecated
        public boolean isMessageHistory() {
            return CamelConfigurationProperties.this.main.isMessageHistory();
        }

        @Deprecated
        public void setMessageHistory(boolean messageHistory) {
            CamelConfigurationProperties.this.main.setMessageHistory(messageHistory);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.source-location-enabled", since="4.5.0")
        @Deprecated
        public boolean isSourceLocationEnabled() {
            return CamelConfigurationProperties.this.main.isSourceLocationEnabled();
        }

        @Deprecated
        public void setSourceLocationEnabled(boolean sourceLocationEnabled) {
            CamelConfigurationProperties.this.main.setSourceLocationEnabled(sourceLocationEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.log-mask", since="4.5.0")
        @Deprecated
        public boolean isLogMask() {
            return CamelConfigurationProperties.this.main.isLogMask();
        }

        @Deprecated
        public void setLogMask(boolean logMask) {
            CamelConfigurationProperties.this.main.setLogMask(logMask);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.log-exhausted-message-body", since="4.5.0")
        @Deprecated
        public boolean isLogExhaustedMessageBody() {
            return CamelConfigurationProperties.this.main.isLogExhaustedMessageBody();
        }

        @Deprecated
        public void setLogExhaustedMessageBody(boolean logExhaustedMessageBody) {
            CamelConfigurationProperties.this.main.setLogExhaustedMessageBody(logExhaustedMessageBody);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.log-name", since="4.5.0")
        @Deprecated
        public String getLogName() {
            return CamelConfigurationProperties.this.main.getLogName();
        }

        @Deprecated
        public void setLogName(String logName) {
            CamelConfigurationProperties.this.main.setLogName(logName);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.log-language", since="4.5.0")
        @Deprecated
        public String getLogLanguage() {
            return CamelConfigurationProperties.this.main.getLogLanguage();
        }

        @Deprecated
        public void setLogLanguage(String logLanguage) {
            CamelConfigurationProperties.this.main.setLogLanguage(logLanguage);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.auto-startup", since="4.5.0")
        @Deprecated
        public boolean isAutoStartup() {
            return CamelConfigurationProperties.this.main.isAutoStartup();
        }

        @Deprecated
        public void setAutoStartup(boolean autoStartup) {
            CamelConfigurationProperties.this.main.setAutoStartup(autoStartup);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.auto-startup-exclude-pattern", since="4.5.0")
        @Deprecated
        public String getAutoStartupExcludePattern() {
            return CamelConfigurationProperties.this.main.getAutoStartupExcludePattern();
        }

        @Deprecated
        public void setAutoStartupExcludePattern(String autoStartupExcludePattern) {
            CamelConfigurationProperties.this.main.setAutoStartupExcludePattern(autoStartupExcludePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.allow-use-original-message", since="4.5.0")
        @Deprecated
        public boolean isAllowUseOriginalMessage() {
            return CamelConfigurationProperties.this.main.isAllowUseOriginalMessage();
        }

        @Deprecated
        public void setAllowUseOriginalMessage(boolean allowUseOriginalMessage) {
            CamelConfigurationProperties.this.main.setAllowUseOriginalMessage(allowUseOriginalMessage);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.case-insensitive-headers", since="4.5.0")
        @Deprecated
        public boolean isCaseInsensitiveHeaders() {
            return CamelConfigurationProperties.this.main.isCaseInsensitiveHeaders();
        }

        @Deprecated
        public void setCaseInsensitiveHeaders(boolean caseInsensitiveHeaders) {
            CamelConfigurationProperties.this.main.setCaseInsensitiveHeaders(caseInsensitiveHeaders);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.autowired-enabled", since="4.5.0")
        @Deprecated
        public boolean isAutowiredEnabled() {
            return CamelConfigurationProperties.this.main.isAutowiredEnabled();
        }

        @Deprecated
        public void setAutowiredEnabled(boolean autowiredEnabled) {
            CamelConfigurationProperties.this.main.setAutowiredEnabled(autowiredEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.endpoint-runtime-statistics-enabled", since="4.5.0")
        @Deprecated
        public boolean isEndpointRuntimeStatisticsEnabled() {
            return CamelConfigurationProperties.this.main.isEndpointRuntimeStatisticsEnabled();
        }

        @Deprecated
        public void setEndpointRuntimeStatisticsEnabled(boolean endpointRuntimeStatisticsEnabled) {
            CamelConfigurationProperties.this.main.setEndpointRuntimeStatisticsEnabled(endpointRuntimeStatisticsEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.load-statistics-enabled", since="4.5.0")
        @Deprecated
        public boolean isLoadStatisticsEnabled() {
            return CamelConfigurationProperties.this.main.isLoadStatisticsEnabled();
        }

        @Deprecated
        public void setLoadStatisticsEnabled(boolean loadStatisticsEnabled) {
            CamelConfigurationProperties.this.main.setLoadStatisticsEnabled(loadStatisticsEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.endpoint-lazy-start-producer", since="4.5.0")
        @Deprecated
        public boolean isEndpointLazyStartProducer() {
            return CamelConfigurationProperties.this.main.isEndpointLazyStartProducer();
        }

        @Deprecated
        public void setEndpointLazyStartProducer(boolean endpointLazyStartProducer) {
            CamelConfigurationProperties.this.main.setEndpointLazyStartProducer(endpointLazyStartProducer);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.endpoint-bridge-error-handler", since="4.5.0")
        @Deprecated
        public boolean isEndpointBridgeErrorHandler() {
            return CamelConfigurationProperties.this.main.isEndpointBridgeErrorHandler();
        }

        @Deprecated
        public void setEndpointBridgeErrorHandler(boolean endpointBridgeErrorHandler) {
            CamelConfigurationProperties.this.main.setEndpointBridgeErrorHandler(endpointBridgeErrorHandler);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.use-data-type", since="4.5.0")
        @Deprecated
        public boolean isUseDataType() {
            return CamelConfigurationProperties.this.main.isUseDataType();
        }

        @Deprecated
        public void setUseDataType(boolean useDataType) {
            CamelConfigurationProperties.this.main.setUseDataType(useDataType);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.use-breadcrumb", since="4.5.0")
        @Deprecated
        public boolean isUseBreadcrumb() {
            return CamelConfigurationProperties.this.main.isUseBreadcrumb();
        }

        @Deprecated
        public void setUseBreadcrumb(boolean useBreadcrumb) {
            CamelConfigurationProperties.this.main.setUseBreadcrumb(useBreadcrumb);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.bean-post-processor-enabled", since="4.5.0")
        @Deprecated
        public boolean isBeanPostProcessorEnabled() {
            return CamelConfigurationProperties.this.main.isBeanPostProcessorEnabled();
        }

        @Deprecated
        public void setBeanPostProcessorEnabled(boolean beanPostProcessorEnabled) {
            CamelConfigurationProperties.this.main.setBeanPostProcessorEnabled(beanPostProcessorEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.jmx-management-m-beans-level", since="4.5.0")
        @Deprecated
        public ManagementMBeansLevel getJmxManagementMBeansLevel() {
            return CamelConfigurationProperties.this.main.getJmxManagementMBeansLevel();
        }

        @Deprecated
        public void setJmxManagementMBeansLevel(ManagementMBeansLevel jmxManagementMBeansLevel) {
            CamelConfigurationProperties.this.main.setJmxManagementMBeansLevel(jmxManagementMBeansLevel);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.jmx-management-statistics-level", since="4.5.0")
        @Deprecated
        public ManagementStatisticsLevel getJmxManagementStatisticsLevel() {
            return CamelConfigurationProperties.this.main.getJmxManagementStatisticsLevel();
        }

        @Deprecated
        public void setJmxManagementStatisticsLevel(ManagementStatisticsLevel jmxManagementStatisticsLevel) {
            CamelConfigurationProperties.this.main.setJmxManagementStatisticsLevel(jmxManagementStatisticsLevel);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.jmx-management-name-pattern", since="4.5.0")
        @Deprecated
        public String getJmxManagementNamePattern() {
            return CamelConfigurationProperties.this.main.getJmxManagementNamePattern();
        }

        @Deprecated
        public void setJmxManagementNamePattern(String jmxManagementNamePattern) {
            CamelConfigurationProperties.this.main.setJmxManagementNamePattern(jmxManagementNamePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.jmx-management-register-routes-create-by-kamelet", since="4.5.0")
        @Deprecated
        public boolean isJmxManagementRegisterRoutesCreateByKamelet() {
            return CamelConfigurationProperties.this.main.isJmxManagementRegisterRoutesCreateByKamelet();
        }

        @Deprecated
        public void setJmxManagementRegisterRoutesCreateByKamelet(boolean jmxManagementRegisterRoutesCreateByKamelet) {
            CamelConfigurationProperties.this.main.setJmxManagementRegisterRoutesCreateByKamelet(jmxManagementRegisterRoutesCreateByKamelet);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.jmx-management-register-routes-create-by-template", since="4.5.0")
        @Deprecated
        public boolean isJmxManagementRegisterRoutesCreateByTemplate() {
            return CamelConfigurationProperties.this.main.isJmxManagementRegisterRoutesCreateByTemplate();
        }

        @Deprecated
        public void setJmxManagementRegisterRoutesCreateByTemplate(boolean jmxManagementRegisterRoutesCreateByTemplate) {
            CamelConfigurationProperties.this.main.setJmxManagementRegisterRoutesCreateByTemplate(jmxManagementRegisterRoutesCreateByTemplate);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.camel-events-timestamp-enabled", since="4.5.0")
        @Deprecated
        public boolean isCamelEventsTimestampEnabled() {
            return CamelConfigurationProperties.this.main.isCamelEventsTimestampEnabled();
        }

        @Deprecated
        public void setCamelEventsTimestampEnabled(boolean camelEventsTimestampEnabled) {
            CamelConfigurationProperties.this.main.setCamelEventsTimestampEnabled(camelEventsTimestampEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.use-mdc-logging", since="4.5.0")
        @Deprecated
        public boolean isUseMdcLogging() {
            return CamelConfigurationProperties.this.main.isUseMdcLogging();
        }

        @Deprecated
        public void setUseMdcLogging(boolean useMdcLogging) {
            CamelConfigurationProperties.this.main.setUseMdcLogging(useMdcLogging);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.mdc-logging-keys-pattern", since="4.5.0")
        @Deprecated
        public String getMdcLoggingKeysPattern() {
            return CamelConfigurationProperties.this.main.getMdcLoggingKeysPattern();
        }

        @Deprecated
        public void setMdcLoggingKeysPattern(String mdcLoggingKeysPattern) {
            CamelConfigurationProperties.this.main.setMdcLoggingKeysPattern(mdcLoggingKeysPattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.thread-name-pattern", since="4.5.0")
        @Deprecated
        public String getThreadNamePattern() {
            return CamelConfigurationProperties.this.main.getThreadNamePattern();
        }

        @Deprecated
        public void setThreadNamePattern(String threadNamePattern) {
            CamelConfigurationProperties.this.main.setThreadNamePattern(threadNamePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.route-filter-include-pattern", since="4.5.0")
        @Deprecated
        public String getRouteFilterIncludePattern() {
            return CamelConfigurationProperties.this.main.getRouteFilterIncludePattern();
        }

        @Deprecated
        public void setRouteFilterIncludePattern(String routeFilterIncludePattern) {
            CamelConfigurationProperties.this.main.setRouteFilterIncludePattern(routeFilterIncludePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.route-filter-exclude-pattern", since="4.5.0")
        @Deprecated
        public String getRouteFilterExcludePattern() {
            return CamelConfigurationProperties.this.main.getRouteFilterExcludePattern();
        }

        @Deprecated
        public void setRouteFilterExcludePattern(String routeFilterExcludePattern) {
            CamelConfigurationProperties.this.main.setRouteFilterExcludePattern(routeFilterExcludePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.bean-introspection-extended-statistics", since="4.5.0")
        @Deprecated
        public boolean isBeanIntrospectionExtendedStatistics() {
            return CamelConfigurationProperties.this.main.isBeanIntrospectionExtendedStatistics();
        }

        @Deprecated
        public void setBeanIntrospectionExtendedStatistics(boolean beanIntrospectionExtendedStatistics) {
            CamelConfigurationProperties.this.main.setBeanIntrospectionExtendedStatistics(beanIntrospectionExtendedStatistics);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.bean-introspection-logging-level", since="4.5.0")
        @Deprecated
        public LoggingLevel getBeanIntrospectionLoggingLevel() {
            return CamelConfigurationProperties.this.main.getBeanIntrospectionLoggingLevel();
        }

        @Deprecated
        public void setBeanIntrospectionLoggingLevel(LoggingLevel beanIntrospectionLoggingLevel) {
            CamelConfigurationProperties.this.main.setBeanIntrospectionLoggingLevel(beanIntrospectionLoggingLevel);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-collector-enabled", since="4.5.0")
        @Deprecated
        public boolean isRoutesCollectorEnabled() {
            return CamelConfigurationProperties.this.main.isRoutesCollectorEnabled();
        }

        @Deprecated
        public void setRoutesCollectorEnabled(boolean routesCollectorEnabled) {
            CamelConfigurationProperties.this.main.setRoutesCollectorEnabled(routesCollectorEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-collector-ignore-loading-error", since="4.5.0")
        @Deprecated
        public boolean isRoutesCollectorIgnoreLoadingError() {
            return CamelConfigurationProperties.this.main.isRoutesCollectorIgnoreLoadingError();
        }

        @Deprecated
        public void setRoutesCollectorIgnoreLoadingError(boolean routesCollectorIgnoreLoadingError) {
            CamelConfigurationProperties.this.main.setRoutesCollectorIgnoreLoadingError(routesCollectorIgnoreLoadingError);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.compile-work-dir", since="4.5.0")
        @Deprecated
        public String getCompileWorkDir() {
            return CamelConfigurationProperties.this.main.getCompileWorkDir();
        }

        @Deprecated
        public void setCompileWorkDir(String compileWorkDir) {
            CamelConfigurationProperties.this.main.setCompileWorkDir(compileWorkDir);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.java-routes-include-pattern", since="4.5.0")
        @Deprecated
        public String getJavaRoutesIncludePattern() {
            return CamelConfigurationProperties.this.main.getJavaRoutesIncludePattern();
        }

        @Deprecated
        public void setJavaRoutesIncludePattern(String javaRoutesIncludePattern) {
            CamelConfigurationProperties.this.main.setJavaRoutesIncludePattern(javaRoutesIncludePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.java-routes-exclude-pattern", since="4.5.0")
        @Deprecated
        public String getJavaRoutesExcludePattern() {
            return CamelConfigurationProperties.this.main.getJavaRoutesExcludePattern();
        }

        @Deprecated
        public void setJavaRoutesExcludePattern(String javaRoutesExcludePattern) {
            CamelConfigurationProperties.this.main.setJavaRoutesExcludePattern(javaRoutesExcludePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-include-pattern", since="4.5.0")
        @Deprecated
        public String getRoutesIncludePattern() {
            return CamelConfigurationProperties.this.main.getRoutesIncludePattern();
        }

        @Deprecated
        public void setRoutesIncludePattern(String routesIncludePattern) {
            CamelConfigurationProperties.this.main.setRoutesIncludePattern(routesIncludePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-exclude-pattern", since="4.5.0")
        @Deprecated
        public String getRoutesExcludePattern() {
            return CamelConfigurationProperties.this.main.getRoutesExcludePattern();
        }

        @Deprecated
        public void setRoutesExcludePattern(String routesExcludePattern) {
            CamelConfigurationProperties.this.main.setRoutesExcludePattern(routesExcludePattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-reload-enabled", since="4.5.0")
        @Deprecated
        public boolean isRoutesReloadEnabled() {
            return CamelConfigurationProperties.this.main.isRoutesReloadEnabled();
        }

        @Deprecated
        public void setRoutesReloadEnabled(boolean routesReloadEnabled) {
            CamelConfigurationProperties.this.main.setRoutesReloadEnabled(routesReloadEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.context-reload-enabled", since="4.5.0")
        @Deprecated
        public boolean isContextReloadEnabled() {
            return CamelConfigurationProperties.this.main.isContextReloadEnabled();
        }

        @Deprecated
        public void setContextReloadEnabled(boolean contextReloadEnabled) {
            CamelConfigurationProperties.this.main.setContextReloadEnabled(contextReloadEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-reload-directory", since="4.5.0")
        @Deprecated
        public String getRoutesReloadDirectory() {
            return CamelConfigurationProperties.this.main.getRoutesReloadDirectory();
        }

        @Deprecated
        public void setRoutesReloadDirectory(String routesReloadDirectory) {
            CamelConfigurationProperties.this.main.setRoutesReloadDirectory(routesReloadDirectory);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-reload-directory-recursive", since="4.5.0")
        @Deprecated
        public boolean isRoutesReloadDirectoryRecursive() {
            return CamelConfigurationProperties.this.main.isRoutesReloadDirectoryRecursive();
        }

        @Deprecated
        public void setRoutesReloadDirectoryRecursive(boolean routesReloadDirectoryRecursive) {
            CamelConfigurationProperties.this.main.setRoutesReloadDirectoryRecursive(routesReloadDirectoryRecursive);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-reload-pattern", since="4.5.0")
        @Deprecated
        public String getRoutesReloadPattern() {
            return CamelConfigurationProperties.this.main.getRoutesReloadPattern();
        }

        @Deprecated
        public void setRoutesReloadPattern(String routesReloadPattern) {
            CamelConfigurationProperties.this.main.setRoutesReloadPattern(routesReloadPattern);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-reload-remove-all-routes", since="4.5.0")
        @Deprecated
        public boolean isRoutesReloadRemoveAllRoutes() {
            return CamelConfigurationProperties.this.main.isRoutesReloadRemoveAllRoutes();
        }

        @Deprecated
        public void setRoutesReloadRemoveAllRoutes(boolean routesReloadRemoveAllRoutes) {
            CamelConfigurationProperties.this.main.setRoutesReloadRemoveAllRoutes(routesReloadRemoveAllRoutes);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.routes-reload-restart-duration", since="4.5.0")
        @Deprecated
        public boolean isRoutesReloadRestartDuration() {
            return CamelConfigurationProperties.this.main.isRoutesReloadRestartDuration();
        }

        @Deprecated
        public void setRoutesReloadRestartDuration(boolean routesReloadRestartDuration) {
            CamelConfigurationProperties.this.main.setRoutesReloadRestartDuration(routesReloadRestartDuration);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.jmx-update-route-enabled", since="4.5.0")
        @Deprecated
        public boolean isJmxUpdateRouteEnabled() {
            return CamelConfigurationProperties.this.main.isJmxUpdateRouteEnabled();
        }

        @Deprecated
        public void setJmxUpdateRouteEnabled(boolean jmxUpdateRouteEnabled) {
            CamelConfigurationProperties.this.main.setJmxUpdateRouteEnabled(jmxUpdateRouteEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.exchange-factory", since="4.5.0")
        @Deprecated
        public String getExchangeFactory() {
            return CamelConfigurationProperties.this.main.getExchangeFactory();
        }

        @Deprecated
        public void setExchangeFactory(String exchangeFactory) {
            CamelConfigurationProperties.this.main.setExchangeFactory(exchangeFactory);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.exchange-factory-capacity", since="4.5.0")
        @Deprecated
        public int getExchangeFactoryCapacity() {
            return CamelConfigurationProperties.this.main.getExchangeFactoryCapacity();
        }

        @Deprecated
        public void setExchangeFactoryCapacity(int exchangeFactoryCapacity) {
            CamelConfigurationProperties.this.main.setExchangeFactoryCapacity(exchangeFactoryCapacity);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.exchange-factory-statistics-enabled", since="4.5.0")
        @Deprecated
        public boolean isExchangeFactoryStatisticsEnabled() {
            return CamelConfigurationProperties.this.main.isExchangeFactoryStatisticsEnabled();
        }

        @Deprecated
        public void setExchangeFactoryStatisticsEnabled(boolean exchangeFactoryStatisticsEnabled) {
            CamelConfigurationProperties.this.main.setExchangeFactoryStatisticsEnabled(exchangeFactoryStatisticsEnabled);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.dump-routes", since="4.5.0")
        @Deprecated
        public String getDumpRoutes() {
            return CamelConfigurationProperties.this.main.getDumpRoutes();
        }

        @Deprecated
        public void setDumpRoutes(String dumpRoutes) {
            CamelConfigurationProperties.this.main.setDumpRoutes(dumpRoutes);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.dump-routes-include", since="4.5.0")
        @Deprecated
        public String getDumpRoutesInclude() {
            return CamelConfigurationProperties.this.main.getDumpRoutesInclude();
        }

        @Deprecated
        public void setDumpRoutesInclude(String dumpRoutesInclude) {
            CamelConfigurationProperties.this.main.setDumpRoutesInclude(dumpRoutesInclude);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.dump-routes-log", since="4.5.0")
        @Deprecated
        public boolean isDumpRoutesLog() {
            return CamelConfigurationProperties.this.main.isDumpRoutesLog();
        }

        @Deprecated
        public void setDumpRoutesLog(boolean dumpRoutesLog) {
            CamelConfigurationProperties.this.main.setDumpRoutesLog(dumpRoutesLog);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.dump-routes-resolve-placeholders", since="4.5.0")
        @Deprecated
        public boolean isDumpRoutesResolvePlaceholders() {
            return CamelConfigurationProperties.this.main.isDumpRoutesResolvePlaceholders();
        }

        @Deprecated
        public void setDumpRoutesResolvePlaceholders(boolean dumpRoutesResolvePlaceholders) {
            CamelConfigurationProperties.this.main.setDumpRoutesResolvePlaceholders(dumpRoutesResolvePlaceholders);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.dump-routes-uri-as-parameters", since="4.5.0")
        @Deprecated
        public boolean isDumpRoutesUriAsParameters() {
            return CamelConfigurationProperties.this.main.isDumpRoutesUriAsParameters();
        }

        @Deprecated
        public void setDumpRoutesUriAsParameters(boolean dumpRoutesUriAsParameters) {
            CamelConfigurationProperties.this.main.setDumpRoutesUriAsParameters(dumpRoutesUriAsParameters);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.dump-routes-generated-ids", since="4.5.0")
        @Deprecated
        public boolean isDumpRoutesGeneratedIds() {
            return CamelConfigurationProperties.this.main.isDumpRoutesGeneratedIds();
        }

        @Deprecated
        public void setDumpRoutesGeneratedIds(boolean dumpRoutesGeneratedIds) {
            CamelConfigurationProperties.this.main.setDumpRoutesGeneratedIds(dumpRoutesGeneratedIds);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.dump-routes-output", since="4.5.0")
        @Deprecated
        public String getDumpRoutesOutput() {
            return CamelConfigurationProperties.this.main.getDumpRoutesOutput();
        }

        @Deprecated
        public void setDumpRoutesOutput(String dumpRoutesOutput) {
            CamelConfigurationProperties.this.main.setDumpRoutesOutput(dumpRoutesOutput);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.global-options", since="4.5.0")
        @Deprecated
        public Map getGlobalOptions() {
            return CamelConfigurationProperties.this.main.getGlobalOptions();
        }

        @Deprecated
        public void setGlobalOptions(Map globalOptions) {
            CamelConfigurationProperties.this.main.setGlobalOptions(globalOptions);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.startup-recorder", since="4.5.0")
        @Deprecated
        public String getStartupRecorder() {
            return CamelConfigurationProperties.this.main.getStartupRecorder();
        }

        @Deprecated
        public void setStartupRecorder(String startupRecorder) {
            CamelConfigurationProperties.this.main.setStartupRecorder(startupRecorder);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.startup-recorder-max-depth", since="4.5.0")
        @Deprecated
        public int getStartupRecorderMaxDepth() {
            return CamelConfigurationProperties.this.main.getStartupRecorderMaxDepth();
        }

        @Deprecated
        public void setStartupRecorderMaxDepth(int startupRecorderMaxDepth) {
            CamelConfigurationProperties.this.main.setStartupRecorderMaxDepth(startupRecorderMaxDepth);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.startup-recorder-recording", since="4.5.0")
        @Deprecated
        public boolean isStartupRecorderRecording() {
            return CamelConfigurationProperties.this.main.isStartupRecorderRecording();
        }

        @Deprecated
        public void setStartupRecorderRecording(boolean startupRecorderRecording) {
            CamelConfigurationProperties.this.main.setStartupRecorderRecording(startupRecorderRecording);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.startup-recorder-profile", since="4.5.0")
        @Deprecated
        public String getStartupRecorderProfile() {
            return CamelConfigurationProperties.this.main.getStartupRecorderProfile();
        }

        @Deprecated
        public void setStartupRecorderProfile(String startupRecorderProfile) {
            CamelConfigurationProperties.this.main.setStartupRecorderProfile(startupRecorderProfile);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.startup-recorder-duration", since="4.5.0")
        @Deprecated
        public long getStartupRecorderDuration() {
            return CamelConfigurationProperties.this.main.getStartupRecorderDuration();
        }

        @Deprecated
        public void setStartupRecorderDuration(long startupRecorderDuration) {
            CamelConfigurationProperties.this.main.setStartupRecorderDuration(startupRecorderDuration);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.startup-recorder-dir", since="4.5.0")
        @Deprecated
        public String getStartupRecorderDir() {
            return CamelConfigurationProperties.this.main.getStartupRecorderDir();
        }

        @Deprecated
        public void setStartupRecorderDir(String startupRecorderDir) {
            CamelConfigurationProperties.this.main.setStartupRecorderDir(startupRecorderDir);
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.cloud-properties-location", since="4.5.0")
        @Deprecated
        public String getCloudPropertiesLocation() {
            return CamelConfigurationProperties.this.main.getCloudPropertiesLocation();
        }

        @Deprecated
        public void setCloudPropertiesLocation(String cloudPropertiesLocation) {
            CamelConfigurationProperties.this.main.setCloudPropertiesLocation(cloudPropertiesLocation);
        }
    }
}

