/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.springboot;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.component.micrometer.springboot.metrics.CamelMetricsConfiguration;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.web.servlet.DefaultWebMvcTagsProvider;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@ConditionalOnProperty(prefix="camel.metrics", name={"uriTagEnabled"}, havingValue="true")
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class MicrometerTagsAutoConfiguration {
    @Autowired
    CamelContext camelContext;

    @Bean
    WebMvcTagsProvider webMvcTagsProvider(final Optional<CamelServlet> servlet, final CamelMetricsConfiguration configuration) {
        return new DefaultWebMvcTagsProvider(){

            public Iterable<Tag> getTags(HttpServletRequest request, HttpServletResponse response, Object handler, Throwable exception) {
                HttpConsumer consumer;
                Object uri = null;
                if (servlet.isPresent() && !configuration.isUriTagDynamic() && (consumer = ((CamelServlet)servlet.get()).getServletResolveConsumerStrategy().resolve(request, ((CamelServlet)servlet.get()).getConsumers())) != null) {
                    uri = consumer.getPath();
                }
                if (uri == null || ((String)uri).isEmpty()) {
                    uri = request.getServletPath();
                    if (uri == null || ((String)uri).isEmpty()) {
                        uri = request.getPathInfo();
                    } else {
                        String p = request.getPathInfo();
                        if (p != null) {
                            uri = (String)uri + p;
                        }
                    }
                }
                if (uri == null) {
                    uri = "";
                }
                return Tags.concat((Iterable)super.getTags(request, response, handler, exception), (Iterable)Tags.of((Tag[])new Tag[]{Tag.of((String)"uri", (String)uri)}));
            }
        };
    }
}

