/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.component.jackson.springboot.JacksonDataFormatConfiguration;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.DataFormatConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={DataFormatConfigurationProperties.class, JacksonDataFormatConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.dataformat", "camel.dataformat.jackson"})
public class JacksonDataFormatAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private JacksonDataFormatConfiguration configuration;

    public JacksonDataFormatAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public DataFormatCustomizer configureJacksonDataFormatFactory() {
        return new DataFormatCustomizer(){

            public void configure(String name, DataFormat target) {
                CamelPropertiesHelper.copyProperties((CamelContext)JacksonDataFormatAutoConfiguration.this.camelContext, (Object)((Object)JacksonDataFormatAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, DataFormat target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)JacksonDataFormatAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.jackson.customizer"}) && target instanceof JacksonDataFormat;
            }
        };
    }
}

