/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.cache.springboot;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class CaffeineCacheComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, CacheLoader.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, CaffeineConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, RemovalListener.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StatsCounter.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "com.github.benmanes.caffeine.cache.CacheLoader": {
                return this.applicationContext.getBean(ref, CacheLoader.class);
            }
            case "org.apache.camel.component.caffeine.CaffeineConfiguration": {
                return this.applicationContext.getBean(ref, CaffeineConfiguration.class);
            }
            case "com.github.benmanes.caffeine.cache.RemovalListener": {
                return this.applicationContext.getBean(ref, RemovalListener.class);
            }
            case "com.github.benmanes.caffeine.cache.stats.StatsCounter": {
                return this.applicationContext.getBean(ref, StatsCounter.class);
            }
        }
        return null;
    }
}

