/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.BeanScope;
import org.apache.camel.CamelContext;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class BeanComponentConverter
implements GenericConverter {
    private final CamelContext camelContext;

    public BeanComponentConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, BeanScope.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.BeanScope": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, BeanScope.class);
            }
        }
        return null;
    }
}

