/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus.springboot;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class ServiceBusComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, AmqpRetryOptions.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ClientOptions.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ServiceBusConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ProxyOptions.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Duration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ServiceBusReceiverAsyncClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, OffsetDateTime.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ServiceBusSenderAsyncClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ServiceBusTransactionContext.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, TokenCredential.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "com.azure.core.amqp.AmqpRetryOptions": {
                return this.applicationContext.getBean(ref, AmqpRetryOptions.class);
            }
            case "com.azure.core.util.ClientOptions": {
                return this.applicationContext.getBean(ref, ClientOptions.class);
            }
            case "org.apache.camel.component.azure.servicebus.ServiceBusConfiguration": {
                return this.applicationContext.getBean(ref, ServiceBusConfiguration.class);
            }
            case "com.azure.core.amqp.ProxyOptions": {
                return this.applicationContext.getBean(ref, ProxyOptions.class);
            }
            case "java.time.Duration": {
                return this.applicationContext.getBean(ref, Duration.class);
            }
            case "com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient": {
                return this.applicationContext.getBean(ref, ServiceBusReceiverAsyncClient.class);
            }
            case "java.time.OffsetDateTime": {
                return this.applicationContext.getBean(ref, OffsetDateTime.class);
            }
            case "com.azure.messaging.servicebus.ServiceBusSenderAsyncClient": {
                return this.applicationContext.getBean(ref, ServiceBusSenderAsyncClient.class);
            }
            case "com.azure.messaging.servicebus.ServiceBusTransactionContext": {
                return this.applicationContext.getBean(ref, ServiceBusTransactionContext.class);
            }
            case "com.azure.core.credential.TokenCredential": {
                return this.applicationContext.getBean(ref, TokenCredential.class);
            }
        }
        return null;
    }
}

