/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.zeebe.ZeebeComponent;
import org.apache.camel.component.zeebe.ZeebeConstants;
import org.apache.camel.component.zeebe.ZeebeConsumer;
import org.apache.camel.component.zeebe.ZeebeProducer;
import org.apache.camel.component.zeebe.internal.OperationName;
import org.apache.camel.component.zeebe.internal.ZeebeService;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.21.0", scheme="zeebe", title="Zeebe", syntax="zeebe:operationName", category={Category.WORKFLOW, Category.SAAS}, headersClass=ZeebeConstants.class)
public class ZeebeEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriPath(label="common", description="The operation to use", enums="startProcess,cancelProcess,publishMessage,completeJob,failJob,updateJobRetries,worker,throwError,deployResource")
    @Metadata(required=true)
    private OperationName operationName;
    @UriParam(defaultValue="false")
    @Metadata(description="Format the result in the body as JSON.")
    private boolean formatJSON;
    @UriParam
    @Metadata(label="consumer", description="JobKey for the job worker.")
    private String jobKey;
    @UriParam(defaultValue="10")
    @Metadata(label="consumer", description="Timeout for job worker.")
    private int timeout = 10;

    public ZeebeEndpoint() {
    }

    public ZeebeEndpoint(String uri, ZeebeComponent component, OperationName operationName) {
        super(uri, (Component)component);
        this.operationName = operationName;
    }

    public String getServiceUrl() {
        return this.getComponent().getGatewayHost() + ":" + this.getComponent().getGatewayPort();
    }

    public String getServiceProtocol() {
        return "rpc";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.getComponent().getClientId() != null) {
            return Map.of("clientId", this.getComponent().getClientId());
        }
        return null;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.operationName), (String)"operationName");
        return new ZeebeProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)((Object)this.operationName), (String)"operationName");
        ZeebeConsumer consumer = new ZeebeConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void setOperationName(OperationName operationName) {
        this.operationName = operationName;
    }

    public OperationName getOperationName() {
        return this.operationName;
    }

    public void setFormatJSON(boolean formatJSON) {
        this.formatJSON = formatJSON;
    }

    public boolean isFormatJSON() {
        return this.formatJSON;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public void setJobKey(String jobKey) {
        this.jobKey = jobKey;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ZeebeComponent getComponent() {
        return (ZeebeComponent)super.getComponent();
    }

    protected ZeebeService getZeebeService() {
        return this.getComponent().getZeebeService();
    }
}

