/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.xml.pretty;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlPrettyPrinter {
    private XmlPrettyPrinter() {
    }

    private static String padString(int level, int blanks) {
        return " ".repeat(level * blanks);
    }

    public static String colorPrint(String xml, int blanks, boolean declaration, ColorPrintElement color) throws Exception {
        return XmlPrettyPrinter.doParse(xml, blanks, declaration, color);
    }

    public static String pettyPrint(String xml, int blanks) throws Exception {
        return XmlPrettyPrinter.doParse(xml, blanks, false, new NoopColor());
    }

    public static String pettyPrint(String xml, int blanks, boolean declaration) throws Exception {
        return XmlPrettyPrinter.doParse(xml, blanks, declaration, new NoopColor());
    }

    private static String doParse(String xml, final int blanks, final boolean declaration, final ColorPrintElement color) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/namespaces", false);
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        SAXParser parser = factory.newSAXParser();
        final StringBuilder sb = new StringBuilder(256);
        DefaultHandler handler = new DefaultHandler(){
            int indent;
            boolean inElement;

            @Override
            public void declaration(String version, String encoding, String standalone) throws SAXException {
                if (declaration) {
                    StringBuilder lb = new StringBuilder(256);
                    lb.append("<?xml");
                    if (version != null) {
                        lb.append(" version=\"").append(version).append("\"");
                    }
                    if (encoding != null) {
                        lb.append(" encoding=\"").append(encoding).append("\"");
                    }
                    if (standalone != null) {
                        lb.append(" standalone=\"").append(encoding).append("\"");
                    }
                    lb.append("?>");
                    String value = color.color(1, lb.toString());
                    sb.append(value);
                    sb.append("\n");
                }
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                boolean empty;
                this.inElement = true;
                sb.append(XmlPrettyPrinter.padString(this.indent, blanks));
                StringBuilder lb = new StringBuilder(256);
                lb.append("<");
                lb.append(qName);
                boolean bl = empty = attributes.getLength() == 0;
                if (empty) {
                    lb.append(">");
                }
                String value = color.color(2, lb.toString());
                sb.append(value);
                if (!empty) {
                    lb.setLength(0);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String k = color.color(3, attributes.getQName(i));
                        String v = color.color(4, attributes.getValue(i));
                        String eq = color.color(5, "=");
                        String quote = color.color(6, "\"");
                        lb.append(" ").append(k).append(eq).append(quote).append(v).append(quote);
                    }
                    sb.append((CharSequence)lb);
                    value = color.color(2, ">");
                    sb.append(value);
                }
                sb.append("\n");
                ++this.indent;
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                this.inElement = false;
                --this.indent;
                StringBuilder lb = new StringBuilder(256);
                lb.append("</");
                lb.append(qName);
                lb.append(">");
                sb.append(XmlPrettyPrinter.padString(this.indent, blanks));
                String value = color.color(2, lb.toString());
                sb.append(value);
                if (this.indent > 0) {
                    sb.append("\n");
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.inElement && this.indent > 1) {
                    char[] chars = new char[length];
                    System.arraycopy(ch, start, chars, 0, length);
                    String value = color.color(7, new String(chars));
                    sb.append(XmlPrettyPrinter.padString(this.indent, blanks));
                    sb.append(value);
                    sb.append("\n");
                }
            }
        };
        parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), handler);
        return sb.toString();
    }

    @FunctionalInterface
    public static interface ColorPrintElement {
        public static final int DECLARATION = 1;
        public static final int ELEMENT = 2;
        public static final int ATTRIBUTE_KEY = 3;
        public static final int ATTRIBUTE_VALUE = 4;
        public static final int ATTRIBUTE_EQUAL = 5;
        public static final int ATTRIBUTE_QUOTE = 6;
        public static final int VALUE = 7;

        public String color(int var1, String var2);
    }

    private static class NoopColor
    implements ColorPrintElement {
        private NoopColor() {
        }

        @Override
        public String color(int type, String value) {
            return value;
        }
    }
}

