/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wal;

public final class Header {
    public static final int FORMAT_NAME_SIZE = 8;
    public static final String FORMAT_NAME = "camel-wa";
    public static final int CURRENT_FILE_VERSION = 1;
    public static final Header WA_DEFAULT_V1 = new Header("camel-wa", 1);
    public static final int BYTES = 12;
    private final String formatName;
    private final int fileVersion;

    Header(String formatName, int fileVersion) {
        if (formatName == null || formatName.isEmpty()) {
            throw new IllegalArgumentException("The format name is not valid: it's either empty or null");
        }
        if (formatName.length() > 8) {
            throw new IllegalArgumentException("The format name '" + formatName + "' is too short. Its length must be less than 8");
        }
        this.formatName = formatName;
        this.fileVersion = fileVersion;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }
}

