/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.camel.util.concurrent.Rejectable;

public enum ThreadPoolRejectedPolicy {
    Abort,
    CallerRuns;


    public RejectedExecutionHandler asRejectedExecutionHandler() {
        if (this == Abort) {
            return new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    if (!(r instanceof Rejectable)) {
                        throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + executor.toString());
                    }
                    Rejectable rejectable = (Rejectable)((Object)r);
                    rejectable.reject();
                }

                public String toString() {
                    return "Abort";
                }
            };
        }
        if (this == CallerRuns) {
            return new ThreadPoolExecutor.CallerRunsPolicy(){

                public String toString() {
                    return "CallerRuns";
                }
            };
        }
        throw new IllegalArgumentException("Unknown ThreadPoolRejectedPolicy: " + String.valueOf((Object)this));
    }
}

