/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.time.Duration;

public final class StopWatch {
    private long start;

    public StopWatch() {
        this.start = System.nanoTime();
    }

    public StopWatch(long timeMillis) {
        this.start = timeMillis;
    }

    public StopWatch(boolean start) {
        if (start) {
            this.start = System.nanoTime();
        }
    }

    public void restart() {
        this.start = System.nanoTime();
    }

    public boolean isStarted() {
        return this.start > 0L;
    }

    public long taken() {
        if (this.start > 0L) {
            long delta = System.nanoTime() - this.start;
            return Duration.ofNanos(delta).toMillis();
        }
        return 0L;
    }

    public long takenAndRestart() {
        long answer = this.taken();
        this.start = System.nanoTime();
        return answer;
    }
}

