/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.camel.util.ObjectHelper;

public final class PropertiesHelper {
    private PropertiesHelper() {
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        return PropertiesHelper.extractProperties(properties, optionPrefix, true);
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix, boolean remove) {
        if (properties == null) {
            return new LinkedHashMap<String, Object>(0);
        }
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            if (!remove) continue;
            it.remove();
        }
        return rc;
    }

    @Deprecated
    public static Map<String, String> extractStringProperties(Map<String, Object> properties) {
        LinkedHashMap<String, String> rc = new LinkedHashMap<String, String>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue().toString();
            rc.put(name, value);
        }
        return rc;
    }

    public static boolean hasProperties(Map<String, Object> properties, String optionPrefix) {
        ObjectHelper.notNull(properties, "properties");
        if (ObjectHelper.isNotEmpty(optionPrefix)) {
            for (String o : properties.keySet()) {
                String name = o;
                if (!name.startsWith(optionPrefix)) continue;
                return true;
            }
            return false;
        }
        return !properties.isEmpty();
    }

    public static Properties asProperties(String ... properties) {
        if ((properties.length & 1) != 0) {
            throw new InternalError("length is odd");
        }
        Properties answer = new Properties();
        for (int i = 0; i < properties.length; i += 2) {
            answer.setProperty(Objects.requireNonNull(properties[i]), Objects.requireNonNull(properties[i + 1]));
        }
        return answer;
    }

    public static Properties asProperties(Map<String, Object> properties) {
        Properties answer = new Properties();
        answer.putAll(properties);
        return answer;
    }
}

