/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util.srcgen;

import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Annotation {
    Class<? extends java.lang.annotation.Annotation> type;
    LinkedHashMap<String, String> values = new LinkedHashMap();

    public Annotation(Class<? extends java.lang.annotation.Annotation> type) {
        this.type = type;
    }

    public Class<? extends java.lang.annotation.Annotation> getType() {
        return this.type;
    }

    public Annotation setType(Class<? extends java.lang.annotation.Annotation> type) {
        this.type = type;
        return this;
    }

    public Annotation setStringValue(String name, String value) {
        this.values.put(name, Annotation.quote(value));
        return this;
    }

    public Annotation setLiteralValue(String name, String value) {
        this.values.put(name, value);
        return this;
    }

    public Annotation setLiteralValue(String value) {
        return this.setLiteralValue("value", value);
    }

    public Annotation setStringArrayValue(String name, String[] values) {
        if (values.length == 1) {
            return this.setStringValue(name, values[0]);
        }
        String value = Stream.of(values).map(Annotation::quote).collect(Collectors.joining(", ", "{", "}"));
        return this.setLiteralValue(value);
    }

    public String getStringValue(String name) {
        String v = this.values.get(name);
        return v != null ? Annotation.unquote(v) : null;
    }

    private static String unquote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String quote(String value) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\') {
                if (sb != null) continue;
                sb = new StringBuilder(value.length() + 8);
                sb.append("\"");
                sb.append("\\");
                sb.append(c);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return "\"" + value + "\"";
        }
        sb.append("\"");
        return sb.toString();
    }
}

