/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.chatscript.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.chatscript.services.ChatScriptInfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

@InfraService(service=ChatScriptInfraService.class, description="ChatBot Engine", serviceAlias={"chat-script"})
public class ChatScriptLocalContainerInfraService
implements ChatScriptInfraService,
ContainerService<GenericContainer<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(ChatScriptLocalContainerInfraService.class);
    private static final int SERVICE_PORT = 1024;
    private GenericContainer<?> container;

    public ChatScriptLocalContainerInfraService() {
        String containerName = LocalPropertyResolver.getProperty(ChatScriptLocalContainerInfraService.class, (String)"chatscript.container");
        this.container = new GenericContainer(containerName).withExposedPorts(new Integer[]{1024}).withCreateContainerCmdModifier(createContainerCmd -> createContainerCmd.withTty(Boolean.valueOf(true)));
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public void registerProperties() {
        System.setProperty("chatscript.address", this.serviceAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the ChatScript container");
        this.container.start();
        this.registerProperties();
        LOG.info("ChatScript instance running at {}", (Object)this.serviceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the ChatScript container");
        this.container.stop();
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public String serviceAddress() {
        return this.container.getHost() + ":" + this.container.getMappedPort(1024);
    }
}

