/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.decorators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;

class HttpMethodHelper {
    private static final Pattern HTTP_METHOD_PATTERN = Pattern.compile("(?i)httpMethod=([A-Z]+)");

    HttpMethodHelper() {
    }

    public static String getHttpMethodFromParameters(Exchange exchange, Endpoint endpoint) {
        String queryString;
        String methodFromQuery;
        String methodFromQuery2;
        String queryStringHeader = (String)exchange.getIn().getHeader("CamelHttpQuery");
        if (queryStringHeader != null && (methodFromQuery2 = HttpMethodHelper.getMethodFromQueryString(queryStringHeader)) != null) {
            return methodFromQuery2;
        }
        int queryIndex = endpoint.getEndpointUri().indexOf(63);
        if (queryIndex != -1 && (methodFromQuery = HttpMethodHelper.getMethodFromQueryString(queryString = endpoint.getEndpointUri().substring(queryIndex + 1))) != null) {
            return methodFromQuery;
        }
        return null;
    }

    private static String getMethodFromQueryString(String queryString) {
        Matcher m = HTTP_METHOD_PATTERN.matcher(queryString);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

