/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetrydev;

import java.util.UUID;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.SpanContextPropagationExtractor;
import org.apache.camel.telemetry.SpanContextPropagationInjector;
import org.apache.camel.telemetry.SpanLifecycleManager;
import org.apache.camel.telemetry.Tracer;
import org.apache.camel.telemetrydev.DevSpanAdapter;
import org.apache.camel.telemetrydev.DevTrace;
import org.apache.camel.telemetrydev.DevTraceFormat;
import org.apache.camel.telemetrydev.DevTraceFormatDefault;
import org.apache.camel.telemetrydev.DevTraceFormatJson;
import org.apache.camel.telemetrydev.DevTraceFormatTree;
import org.apache.camel.telemetrydev.InMemoryCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="telemetry-dev-tracer")
@Configurer
@ManagedResource(description="TelemetryDevTracer")
public class TelemetryDevTracer
extends Tracer {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryDevTracer.class);
    private final Logger LOGTRACE = LoggerFactory.getLogger((String)"LOG_TRACE");
    private String traceFormat;

    @ManagedAttribute(description="The format of traces (default, tree, json)")
    public String getTraceFormat() {
        return this.traceFormat;
    }

    public void setTraceFormat(String traceFormat) {
        this.traceFormat = traceFormat;
    }

    protected void initTracer() {
        this.setSpanLifecycleManager(new DevSpanLifecycleManager(this.traceFormat));
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.warn("TelemetryDevTracer enabled. This is a development tracer and you should avoid using it in production workflows.");
    }

    private static String spanTraceId(Span span) {
        if (span == null) {
            return "";
        }
        return span.toString().split("-")[0];
    }

    private static String spanSpanId(Span span) {
        if (span == null) {
            return "";
        }
        return span.toString().split("-")[1];
    }

    private class DevSpanLifecycleManager
    implements SpanLifecycleManager {
        private final InMemoryCollector inMemoryCollector = new InMemoryCollector();
        private DevTraceFormat stf;

        private DevSpanLifecycleManager(String traceFormat) {
            if (traceFormat == null) {
                traceFormat = "default";
            }
            switch (traceFormat.toLowerCase()) {
                case "tree": {
                    this.stf = new DevTraceFormatTree();
                    break;
                }
                case "json": {
                    this.stf = new DevTraceFormatJson();
                    break;
                }
                case "default": {
                    this.stf = new DevTraceFormatDefault();
                    break;
                }
                default: {
                    LOG.warn("Unknown {} trace format. Fallback to default.", (Object)traceFormat);
                }
            }
        }

        public Span create(String spanName, Span parent, SpanContextPropagationExtractor extractor) {
            DevSpanAdapter span = DevSpanAdapter.buildSpan(spanName);
            String traceId = UUID.randomUUID().toString().replaceAll("-", "");
            if (parent != null) {
                traceId = TelemetryDevTracer.spanTraceId(parent);
                span.setTag("parentSpan", TelemetryDevTracer.spanSpanId(parent));
            } else {
                String upstreamTraceParent = (String)extractor.get("traceparent");
                if (upstreamTraceParent != null) {
                    String[] split = upstreamTraceParent.toString().split("-");
                    if (split.length != 2) {
                        LOG.error("TRACE ERROR: wrong format, could not split traceparent {}", (Object)upstreamTraceParent);
                        span.setTag("traceid", traceId);
                        span.setTag("spanid", UUID.randomUUID().toString().replaceAll("-", ""));
                        return span;
                    }
                    traceId = split[0];
                    String parentSpanId = split[1];
                    span.setTag("parentSpan", parentSpanId);
                }
            }
            span.setTag("traceid", traceId);
            span.setTag("spanid", UUID.randomUUID().toString().replaceAll("-", ""));
            return span;
        }

        public void activate(Span span) {
            span.setTag("initTimestamp", "" + System.nanoTime());
            DevSpanAdapter ssa = (DevSpanAdapter)span;
            this.inMemoryCollector.push(ssa.getTag("traceid"), ssa);
        }

        public void close(Span span) {
            span.setTag("isDone", "true");
            DevSpanAdapter ssa = (DevSpanAdapter)span;
            DevTrace trace = this.inMemoryCollector.get(ssa.getTag("traceid"));
            if (trace != null) {
                TelemetryDevTracer.this.LOGTRACE.info("{}", (Object)this.stf.format(trace));
            }
        }

        public void deactivate(Span span) {
            span.setTag("endTimestamp", "" + System.nanoTime());
        }

        public void inject(Span span, SpanContextPropagationInjector injector, boolean includeTracing) {
            String[] split = span.toString().split("-");
            if (split.length < 2) {
                LOG.error("TRACE ERROR: wrong format, could not split traceparent {}", (Object)span);
                return;
            }
            injector.put("traceparent", split[0] + "-" + split[1]);
            if (includeTracing) {
                DevSpanAdapter spanAdapter = (DevSpanAdapter)span;
                injector.put("CAMEL_TRACE_ID", spanAdapter.getTag("traceid"));
                injector.put("CAMEL_SPAN_ID", spanAdapter.getTag("spanid"));
            }
        }
    }
}

