/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetrydev;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.camel.telemetrydev.DevSpanAdapter;
import org.apache.camel.telemetrydev.SpanComparator;

public class DevTrace
implements Iterable<DevSpanAdapter> {
    private String traceId;
    private List<DevSpanAdapter> spans;

    DevTrace() {
    }

    public DevTrace(String traceId, List<DevSpanAdapter> spans) {
        this.traceId = traceId;
        this.spans = spans;
        Collections.sort(this.spans, new SpanComparator());
    }

    public String toString() {
        return this.traceId + " " + this.spans.toString();
    }

    public String getTraceId() {
        return this.traceId;
    }

    void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public List<DevSpanAdapter> getSpans() {
        return this.spans;
    }

    public List<DevSpanAdapter> sortSpans() {
        ArrayList<DevSpanAdapter> spans = new ArrayList<DevSpanAdapter>();
        for (DevSpanAdapter span : this) {
            spans.add(span);
        }
        return spans;
    }

    void setSpans(List<DevSpanAdapter> spans) {
        this.spans = spans;
    }

    @Override
    public Iterator<DevSpanAdapter> iterator() {
        return new DevSpanAdapterIterator();
    }

    class DevSpanAdapterIterator
    implements Iterator<DevSpanAdapter> {
        Stack<DevSpanAdapter> actual = new Stack();
        private HashMap<String, Boolean> scanned = new HashMap();

        DevSpanAdapterIterator() {
            this.actual = new Stack();
        }

        @Override
        public boolean hasNext() {
            return this.scanned.size() < DevTrace.this.spans.size();
        }

        @Override
        public DevSpanAdapter next() {
            DevSpanAdapter next = this.actual.empty() ? this.getWithParent(null) : this.getWithParent(this.actual.peek().getSpanId());
            while (next == null && !this.actual.empty()) {
                DevSpanAdapter upperLevel = this.actual.pop();
                next = this.getWithParent(upperLevel.getParentSpanId());
            }
            if (next != null) {
                this.actual.push(next);
                this.scanned.put(next.getSpanId(), true);
            }
            return next;
        }

        private DevSpanAdapter getWithParent(String parentSpanId) {
            for (DevSpanAdapter span : DevTrace.this.spans) {
                if (parentSpanId == null && span.getParentSpanId() == null && !this.scanned.containsKey(span.getSpanId())) {
                    return span;
                }
                if (span.getParentSpanId() == null || !span.getParentSpanId().equals(parentSpanId) || this.scanned.containsKey(span.getSpanId())) continue;
                return span;
            }
            return null;
        }
    }
}

