/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultAudio
extends InlineQueryResult {
    private static final String TYPE = "audio";
    @JsonProperty(value="audio_url")
    private String audioUrl;
    @JsonProperty(value="audio_duration")
    private Integer audioDuration;
    private String title;
    private String caption;
    private String performer;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultAudio() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAudioUrl() {
        return this.audioUrl;
    }

    public Integer getAudioDuration() {
        return this.audioDuration;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setAudioUrl(String audioUrl) {
        this.audioUrl = audioUrl;
    }

    public void setAudioDuration(Integer audioDuration) {
        this.audioDuration = audioDuration;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setPerformer(String performer) {
        this.performer = performer;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String audioUrl;
        private Integer audioDuration;
        private String title;
        private String caption;
        private String performer;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder audioUrl(String url) {
            this.audioUrl = url;
            return this;
        }

        public Builder audioDuration(Integer duration) {
            this.audioDuration = duration;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder performer(String performer) {
            this.performer = performer;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultAudio build() {
            InlineQueryResultAudio inlineQueryResultAudio = new InlineQueryResultAudio();
            inlineQueryResultAudio.setId(this.id);
            inlineQueryResultAudio.setType(InlineQueryResultAudio.TYPE);
            inlineQueryResultAudio.setReplyMarkup(this.replyMarkup);
            inlineQueryResultAudio.parseMode = this.parseMode;
            inlineQueryResultAudio.title = this.title;
            inlineQueryResultAudio.caption = this.caption;
            inlineQueryResultAudio.performer = this.performer;
            inlineQueryResultAudio.audioUrl = this.audioUrl;
            inlineQueryResultAudio.audioDuration = this.audioDuration;
            inlineQueryResultAudio.inputMessageContext = this.inputMessageContext;
            return inlineQueryResultAudio;
        }
    }
}

